<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Testimonials.
 */
class TJ_Testimonial extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-testimonial';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Testimonial', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-testimonial tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script', 'swiper'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style', 'swiper'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'testimonial',
      'testimonials',
      'tj testimonial',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Testimonial Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
          7 => esc_html__('Style 07', 'tjcore'),
          8 => esc_html__('Style 08', 'tjcore'),
          9 => esc_html__('Style 09', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // _tj_section_content
    $this->start_controls_section(
      '_tj_review_content',
      [
        'label' => esc_html__('Review Content', 'tjcore'),
      ]
    );

    $repeater = new Repeater();
    $repeater->add_control(
      'field_condition',
      [
        'label' => __('Field condition', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          1 => __('Style 01', 'tjcore'),
          2 => __('Style 02', 'tjcore'),
        ],
        'default' => '1',
        'frontend_available' => true,
        'style_transfer' => true,
      ]
    );
    $repeater->add_control(
      'tj_testi_image',
      [
        'label'   => esc_html__('Reviewer Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],

      ]
    );
    $repeater->add_control(
      'tj_testi_name',
      [
        'label'       => esc_html__('Name', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Florence R. Ochoa', 'tjcore'),
        'label_block' => true,
      ]
    );
    $repeater->add_control(
      'tj_testi_designation',
      [
        'label'       => esc_html__('Designation', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Sr. Executive', 'tjcore'),
        'label_block' => true,
      ]
    );
    $repeater->add_control(
      'tj_testi_rating',
      [
        'label'      => esc_html__('Rating', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['%'],
        'range'      => [
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => 80,
        ],
        'condition' => [
          'field_condition!' => ['2'],
        ],
      ]
    );

    $repeater->add_control(
      'tj_testi_text',
      [
        'label'   => esc_html__('Review Text', 'tjcore'),
        'type'    => Controls_Manager::TEXTAREA,
        'default' => esc_html__('scelerisque netus auctor suscipit vehicula one pellentesque elementum vehicula adipiscing natoque tortor fermentum fermentum to pellentesque per interdum este mauris.', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_testi_list',
      [
        'label'       => esc_html__('Review - List', 'tjcore'),
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater->get_controls(),
        'default'     => [
          [
            'tj_testi_name'        => esc_html__('Florence R. Ochoa', 'tjcore'),
            'tj_testi_designation' => esc_html__('Sr. Executive', 'tjcore'),
          ],
          [
            'tj_testi_name'        => esc_html__('Debra R. Barnes', 'tjcore'),
            'tj_testi_designation' => esc_html__('Business owner', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ tj_testi_name }}}',
      ]
    );

    $this->add_control(
      'tj_quote_icon',
      [
        'label' => esc_html__('Quote Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-right-quote',
          'library' => 'tji',
        ],
        'fa4compatibility' => 'quote_icon',
        'condition' => [
          'tj_design_style!' => ['5', '7', '9']
        ]
      ]
    );

    // animation
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    // slider settings
    $this->start_controls_section(
      '__tj_slider_settings',
      [
        'label' => esc_html__('Slider Settings', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tj_design_style!' => ['6']
        ]
      ]
    );

    $this->add_control(
      'slide_loop',
      [
        'label'        => esc_html__('Is Loop?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider item loop?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'condition' => [
          'tj_design_style!' => ['7']
        ]
      ]
    );
    $this->add_control(
      'slide_dot',
      [
        'label'        => esc_html__('Is Dots?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to show slider dots?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'condition' => [
          'tj_design_style!' => ['7']
        ]
      ]
    );
    $this->add_control(
      'slide_nav',
      [
        'label'        => esc_html__('Is Nav?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to show slider navigation?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'condition' => [
          'tj_design_style!' => ['7', '9']
        ]
      ]
    );
    $this->add_control(
      'slide_autoplay',
      [
        'label'        => esc_html__('Is Autoplay?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider auto play?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'condition' => [
          'tj_design_style!' => ['7']
        ]
      ]
    );
    $this->add_control(
      'slide_autoplay_Delay',
      [
        'label'       => esc_html__('Autoplay Delay', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'description' => esc_html__('Set slider autoplay delay.', 'tjcore'),
        'min'         => 1000,
        'max'         => 10000,
        'step'        => 100,
        'default'     => 5000,
        'condition'   => [
          'slide_autoplay' => 'yes',
          'tj_design_style!' => ['7']
        ],
      ]
    );
    $this->add_control(
      'slide_direction',
      [
        'label'   => esc_html__('Select Direction', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          'tj-slider-up' => esc_html__('Bottom To Top', 'tjcore'),
          'tj-slider-down' => esc_html__('Top To Bottom', 'tjcore'),
        ],
        'default' => 'tj-slider-up',
        'condition' => [
          'tj_design_style!' => ['1', '2', '3', '4', '5', '6', '8', '9']
        ]
      ]
    );

    $this->add_control(
      'tj_device_options',
      [
        'label' => esc_html__('Breakpoint Options below:', 'tjcore'),
        'type' => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
        'condition' => [
          'tj_design_style' => ['1', '3', '4', '5', '9']
        ]
      ]
    );
    $bootstrap_breakpoints = [
      'xs'  => 'Mobile (<576px)',
      'sm'  => 'Large Moblie (≥576px)',
      'md'  => 'Tablet (≥768px)',
      'lg'  => 'Large (≥992px)',
      'xl'  => 'Laptop (≥1200px)',
      'xxl' => 'Desktop  (≥1400px)',
    ];
    foreach ($bootstrap_breakpoints as $key => $label) {
      $this->add_control(
        'tj_' . $key . '_preview',
        [
          'label'       => sprintf(esc_html__('%s Device Item', 'tjcore'), $label),
          'type'        => \Elementor\Controls_Manager::NUMBER,
          'default'     => '',
          'separator' => 'before',
          'condition' => [
            'tj_design_style' => ['1', '3', '4', '5', '9']
          ]
        ]
      );
      $this->add_control(
        'tj_' . $key . '_space',
        [
          'label'       => __('Space Between', 'tjcore'),
          'type'        => \Elementor\Controls_Manager::NUMBER,
          'default'     => '',
          'condition' => [
            'tj_design_style' => ['1', '3', '4', '5', '9']
          ]
        ]
      );
    }

    $this->end_controls_section();

    $this->start_controls_section(
      'gsap_swipe_animation_content',
      [
        'label' => esc_html__('Swipe Animation', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tj_design_style!' => ['7', '2', '6', '8']
        ]
      ]
    );
    $this->add_control(
      'gsap_swipe_direction',
      [
        'label'   => esc_html__('Select Direction', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'right-swipe' => esc_html__('Right Swipe', 'tjcore'),
          'left-swipe' => esc_html__('Left Swipe', 'tjcore'),
        ],
        'default' => '',
      ]
    );
    $this->end_controls_section();
    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      'section_style_fcontent',
      [
        'label' => esc_html__('Wrapper style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_wrapper_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-el-item',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .tj-el-item',
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-el-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-el-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // icon
    $this->start_controls_section(
      'section_style_ficon',
      [
        'label' => esc_html__('Icon style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['5', '9']
        ]
      ]
    );
    $this->add_responsive_control(
      'ficon_font_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-el-item .el-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'ficon_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-item .el-icon i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'ficon_bgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-item .el-icon' => 'background: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style!' => ['6']
        ]
      ]
    );
    $this->end_controls_section();

    // content
    $this->start_controls_section(
      '_style_fcontent',
      [
        'label'     => esc_html__('Content', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_content_typography',
        'selector' => '{{WRAPPER}} .tj-el-item .desc',
      ]
    );
    $this->add_control(
      'tj_content_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-item .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-el-item .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-el-item .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_ftitle',
      [
        'label' => esc_html__('Name', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .tj-el-item .el-title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-item .el-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-el-item .el-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-el-item .el-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Designation
    $this->start_controls_section(
      '_style_test_stitle',
      [
        'label' => esc_html__('Designation', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_test_stitle_typography',
        'selector' => '{{WRAPPER}} .tj-el-item .el-stitle',
      ]
    );
    $this->add_control(
      'tj_test_stitle_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-item .el-stitle' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_test_stitle_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-el-item .el-stitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_test_stitle_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-el-item .el-stitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Rating
    $this->start_controls_section(
      'section_rating_style',
      [
        'label' => esc_html__('Rating Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['8']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'rating_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .star-ratings > *, {{WRAPPER}} .star-ratings',
      ]
    );
    $this->add_control(
      'ricon_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .star-ratings > *' => 'color: {{VALUE}}',
          '{{WRAPPER}} .star-ratings .fill-ratings' => 'color: {{VALUE}}',
          '{{WRAPPER}} .star-ratings ' => '-webkit-text-stroke-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'rtext_bgcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-rating .star-fill' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .el-rating' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'text_rating_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .el-rating .star-fill' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .el-rating ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // pagination
    $this->start_controls_section(
      '_style_test_pagination',
      [
        'label' => esc_html__('Pagination Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['2', '6'],
        ],
      ]
    );
    $this->add_control(
      'tj_test_paginaton_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .swiper_pagination .swiper-pagination-bullet::after' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_test_paginaton_border_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .swiper_pagination .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

    // navigation
    $this->start_controls_section(
      'section_nav_style',
      [
        'label' => esc_html__('Navigation', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style' => ['2', '8'],
        ],
      ]
    );
    $this->start_controls_tabs('navs_tabs');
    $this->start_controls_tab(
      'nav_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .navigation i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-next' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .slider-prev' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-next' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .slider-prev' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'nav_style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'icon_hover_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .navigation:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_bg_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-next:hover' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .slider-prev:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_border_hcolor',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-next:hover' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .slider-prev:hover' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/testimonial/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Testimonial());
