<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

class Tj_Text_Widget extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-text';
  }

  // widget title.
  public function get_title() {
    return esc_html__('TJ Paragraph', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-text tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'text',
      'paragraph',
      'tj text',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    $this->start_controls_section(
      'tj_section_content',
      [
        'label' => esc_html__('Text Editor', 'tjcore'),
      ]
    );
    $this->add_control(
      'text_content',
      [
        'label'      => esc_html__('Description', 'tjcore'),
        'default'    => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'tjcore'),
        'type'       => Controls_Manager::WYSIWYG,
        'show_label' => false,
        'dynamic'    => [
          'active' => true,
        ],
      ]
    );
    $this->add_responsive_control(
      'text_alignment',
      [
        'label'     => esc_html__('Alignment', 'tjcore'),
        'type'      => Controls_Manager::CHOOSE,
        'options'   => [
          'left'    => [
            'title' => esc_html__('Left', 'tjcore'),
            'icon'  => 'eicon-text-align-left',
          ],
          'center'  => [
            'title' => esc_html__('Center', 'tjcore'),
            'icon'  => 'eicon-text-align-center',
          ],
          'right'   => [
            'title' => esc_html__('Right', 'tjcore'),
            'icon'  => 'eicon-text-align-right',
          ],
          'justify' => [
            'title' => esc_html__('Justify', 'tjcore'),
            'icon'  => 'eicon-text-align-justify',
          ],
        ],
        'default'   => 'left',
        'selectors' => [
          '{{WRAPPER}} .editor_text' => 'text-align: {{VALUE}};',
        ],
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      'section_editor_style',
      [
        'label' => esc_html__('Text Editor', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'text_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .editor_text',
      ]
    );
    $this->add_control(
      'text_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .editor_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'text_editor_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .editor_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'text_editor_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .editor_text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  protected function render() {
    $settings = $this->get_settings_for_display();

    // animation
    $tjAnimation      = $settings['tj_animation'] ?? '';
    $tjAnimationName  = $settings['tj_animation_name'] ?? '';
    $tjAnimationDelay = $settings['tj_animation_delay'] ?? '';

    if (!empty($tjAnimation)) {
      $editorClass = "editor_text wow $tjAnimationName";
      $this->add_render_attribute('tj-editor-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
    } else {
      $editorClass = "editor_text";
    }
    $this->add_render_attribute('tj-editor-arg', 'class', $editorClass);

    $editor_content = $settings['text_content'] ?? "";

    if (!empty($editor_content)): ?>
      <div <?php echo $this->get_render_attribute_string('tj-editor-arg'); ?>><?php echo tj_kses($editor_content); ?></div>
<?php endif;
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new Tj_Text_Widget());
