<?php

/**
 * TJ Helper Functions
 *
 *
 * @author   ThemeJunction 
 * @package  TJCore
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
  die('Direct access forbidden.');
}

/** ---------------------------------------------------------------
 * Get All Pages
 *---------------------------------------------------------------*/
if (!function_exists('tj_get_all_pages')) {
  function tj_get_all_pages()
  {

    $page_list = get_posts(array(
      'post_type'      => 'page',
      'orderby'        => 'date',
      'order'          => 'DESC',
      'posts_per_page' => -1,
    ));

    $pages = array();

    if (!empty($page_list) && !is_wp_error($page_list)) {
      foreach ($page_list as $page) {
        $pages[$page->ID] = $page->post_title;
      }
    }

    return $pages;
  }
}

/** ---------------------------------------------------------------
 * Get Post Types
 *---------------------------------------------------------------*/
if (!function_exists('tj_get_post_types')) {
  function tj_get_post_types()
  {

    $tj_cptj         = get_post_types(['public' => true, 'show_in_nav_menus' => true], 'object');
    $tj_exclude_cpts = ['elementor_library', 'attachment'];
    foreach ($tj_exclude_cpts as $exclude_cpt) {
      unset($tj_cpts[$exclude_cpt]);
    }
    $post_types = array_merge($tj_cpts);
    foreach ($post_types as $type) {
      $types[$type->name] = $type->label;
    }
    return $types;
  }
}

/** ---------------------------------------------------------------
 * Get All Types Post
 *---------------------------------------------------------------*/
if (!function_exists('tj_get_all_types_post')) {
  function tj_get_all_types_post($post_type)
  {

    $posts_args = get_posts(array(
      'post_type'      => $post_type,
      'orderby'        => 'date',
      'order'          => 'DESC',
      'post_status'    => 'publish',
      'posts_per_page' => -1,
    ));

    $posts = [];

    if (!empty($posts_args) && !is_wp_error($posts_args)) {
      foreach ($posts_args as $post) {
        $posts[$post->ID] = $post->post_title;
      }
    }

    return $posts;
  }
}

/** ---------------------------------------------------------------
 * Get Thumbnail Sizes
 *---------------------------------------------------------------*/
if (!function_exists('tj_get_thumbnail_sizes')) {
  function tj_get_thumbnail_sizes()
  {
    $sizes = get_intermediate_image_sizes();
    foreach ($sizes as $s) {
      $ret[$s] = $s;
    }
    return $ret;
  }
}

/** ---------------------------------------------------------------
 * Get Order By Options
 *---------------------------------------------------------------*/
if (!function_exists('tj_get_orderby_options')) {
  function tj_get_orderby_options()
  {
    $orderby = array(
      'ID'            => 'Post ID',
      'author'        => 'Post Author',
      'title'         => 'Title',
      'date'          => 'Date',
      'modified'      => 'Last Modified Date',
      'parent'        => 'Parent Id',
      'rand'          => 'Random',
      'comment_count' => 'Comment Count',
      'menu_order'    => 'Menu Order',
    );
    return $orderby;
  }
}

/** ---------------------------------------------------------------
 * Get Categories
 *---------------------------------------------------------------*/
if (!function_exists('tj_get_categories')) {
  function tj_get_categories($taxonomy)
  {
    $terms = get_terms(array(
      'taxonomy'   => $taxonomy,
      'hide_empty' => true,
    ));
    $options = array();
    if (!empty($terms) && !is_wp_error($terms)) {
      foreach ($terms as $term) {
        $options[$term->slug] = $term->name;
      }
    }
    return $options;
  }
}

/**
 * Get all types of post.
 */
function get_post_list($post_type = 'any')
{
  return get_query_post_list($post_type);
}


/**
 * @param string $post_type
 * @param int $limit
 * @param string $search
 * @return array
 */
function get_query_post_list($post_type = 'any', $limit = -1, $search = '')
{
  global $wpdb;
  $where = '';
  $data = [];

  if (-1 == $limit) {
    $limit = '';
  } elseif (0 == $limit) {
    $limit = "limit 0,1";
  } else {
    $limit = $wpdb->prepare(" limit 0,%d", esc_sql($limit));
  }

  if ('any' === $post_type) {
    $in_search_post_types = get_post_types(['exclude_from_search' => false]);
    if (empty($in_search_post_types)) {
      $where .= ' AND 1=0 ';
    } else {
      $where .= " AND {$wpdb->posts}.post_type IN ('" . join(
        "', '",
        array_map('esc_sql', $in_search_post_types)
      ) . "')";
    }
  } elseif (!empty($post_type)) {
    $where .= $wpdb->prepare(" AND {$wpdb->posts}.post_type = %s", esc_sql($post_type));
  }

  if (!empty($search)) {
    $where .= $wpdb->prepare(" AND {$wpdb->posts}.post_title LIKE %s", '%' . esc_sql($search) . '%');
  }

  $query = "select post_title,ID  from $wpdb->posts where post_status = 'publish' $where $limit";
  $results = $wpdb->get_results($query);
  if (!empty($results)) {
    foreach ($results as $row) {
      $data[$row->ID] = $row->post_title;
    }
  }
  return $data;
}
/** ---------------------------------------------------------------
 * Get Elementor Templates
 *---------------------------------------------------------------*/
if (!function_exists('get_elementor_templates')) {
  function get_elementor_templates($type = null)
  {
    $options = [];

    if ($type) {
      $args = [
        'post_type'      => 'elementor_library',
        'posts_per_page' => -1,
      ];
      $args['tax_query'] = [
        [
          'taxonomy' => 'elementor_library_type',
          'field'    => 'slug',
          'terms'    => $type,
        ],
      ];

      $page_templates = get_posts($args);

      if (!empty($page_templates) && !is_wp_error($page_templates)) {
        foreach ($page_templates as $post) {
          $options[$post->ID] = $post->post_title;
        }
      }
    } else {
      $options = get_query_post_list('elementor_library');
    }

    return $options;
  }
}

/** ---------------------------------------------------------------
 * TJ Render Icon
 *---------------------------------------------------------------*/
if (!function_exists('tj_is_elementor_version')) {
  function tj_is_elementor_version($operator = '<', $version = '2.6.0')
  {
    return defined('ELEMENTOR_VERSION') && version_compare(ELEMENTOR_VERSION, $version, $operator);
  }
}
if (!function_exists('tj_render_icon')) {
  function tj_render_icon($settings = [], $old_icon_id = 'icon', $new_icon_id = 'selected_icon', $attributes = [])
  {
    // Check if its already migrated
    $migrated = isset($settings['__fa4_migrated'][$new_icon_id]);
    // Check if its a new widget without previously selected icon using the old Icon control
    $is_new = empty($settings[$old_icon_id]);

    $attributes['aria-hidden'] = 'true';

    if (tj_is_elementor_version('>=', '2.6.0') && ($is_new || $migrated)) {
      \Elementor\Icons_Manager::render_icon($settings[$new_icon_id], $attributes);
    } else {
      if (empty($attributes['class'])) {
        $attributes['class'] = $settings[$old_icon_id];
      } else {
        if (is_array($attributes['class'])) {
          $attributes['class'][] = $settings[$old_icon_id];
        } else {
          $attributes['class'] .= ' ' . $settings[$old_icon_id];
        }
      }
      printf('<i %s></i>', \Elementor\Utils::render_html_attributes($attributes));
    }
  }
}

/**
 * Sanitize HTML content using an extended KSES ruleset.
 *
 * @param string $raw The raw HTML input.
 * @return string Sanitized HTML.
 */
function tj_kses($raw)
{

  // -------------------------------------------------------
  // 1. Global HTML attributes applied to all elements.
  //    (Based on HTML5 + WP Core safe attributes)
  // -------------------------------------------------------
  $global_atts = array(
    'accesskey'   => true,
    'class'       => true,
    'contenteditable' => true,
    'dir'         => true,
    'draggable'   => true,
    'id'          => true,
    'lang'        => true,
    'spellcheck'  => true,
    'style'       => true,
    'tabindex'    => true,
    'title'       => true,
    'translate'   => true,

    // HTML5 Global Data Attributes
    'data-*'      => true,

    // Custom data attributes you used
    'data-wow-duration'             => true,
    'data-wow-delay'                => true,
    'data-wallpaper-options'        => true,
    'data-stellar-background-ratio' => true,
  );

  // -------------------------------------------------------
  // 2. Tag-Specific Attributes (HTML5 + WP Core safe)
  // -------------------------------------------------------
  $tag_specific = array(

    // Anchor
    'a' => array(
      'href'      => true,
      'rel'       => true,
      'target'    => true,
      'download'  => true,
      'hreflang'  => true,
      'type'      => true,
    ),

    // Images
    'img' => array(
      'alt'        => true,
      'src'        => true,
      'srcset'     => true,
      'sizes'      => true,
      'width'      => true,
      'height'     => true,
      'loading'    => true,
      'decoding'   => true,
      'crossorigin' => true,
      'referrerpolicy' => true,
    ),

    // Iframe
    'iframe' => array(
      'src'         => true,
      'width'       => true,
      'height'      => true,
      'allow'       => true,
      'allowfullscreen' => true,
      'frameborder' => true,
      'scrolling'   => true,
      'loading'     => true,
      'referrerpolicy' => true,
    ),

    // Video
    'video' => array(
      'src'       => true,
      'poster'    => true,
      'preload'   => true,
      'autoplay'  => true,
      'controls'  => true,
      'loop'      => true,
      'muted'     => true,
      'playsinline' => true,
      'width'     => true,
      'height'    => true,
    ),

    // Audio
    'audio' => array(
      'src'       => true,
      'preload'   => true,
      'autoplay'  => true,
      'controls'  => true,
      'loop'      => true,
      'muted'     => true,
    ),

    // Form elements
    'input' => array(
      'type'        => true,
      'name'        => true,
      'value'       => true,
      'placeholder' => true,
      'checked'     => true,
      'disabled'    => true,
      'readonly'    => true,
      'required'    => true,
      'min'         => true,
      'max'         => true,
      'step'        => true,
      'pattern'     => true,
    ),

    'textarea' => array(
      'name'        => true,
      'placeholder' => true,
      'rows'        => true,
      'cols'        => true,
      'maxlength'   => true,
      'minlength'   => true,
      'required'    => true,
      'readonly'    => true,
    ),

    'select' => array(
      'name'     => true,
      'multiple' => true,
      'required' => true,
    ),

    'option' => array(
      'value'    => true,
      'selected' => true,
    ),

    // List elements
    'ol' => array(
      'type' => true,
      'start' => true,
    ),
    'li' => array(
      'value' => true,
    ),

    // Quote
    'q' => array(
      'cite' => true,
    ),
    'blockquote' => array(
      'cite' => true,
    ),

    // Table support
    'table' => array(),
    'thead' => array(),
    'tbody' => array(),
    'tfoot' => array(),
    'tr'    => array(),
    'td'    => array(
      'colspan' => true,
      'rowspan' => true,
    ),
    'th'    => array(
      'colspan' => true,
      'rowspan' => true,
      'scope'   => true,
    ),

  );

  // -------------------------------------------------------
  // 3. Expanded HTML5 tags allowed
  // -------------------------------------------------------
  $allowed_tags = array(
    'a',
    'abbr',
    'address',
    'article',
    'aside',
    'audio',
    'b',
    'bdi',
    'bdo',
    'big',
    'blockquote',
    'br',
    'caption',
    'cite',
    'code',
    'col',
    'colgroup',
    'data',
    'dd',
    'del',
    'details',
    'dfn',
    'div',
    'dl',
    'dt',
    'em',
    'figcaption',
    'figure',
    'footer',
    'form',
    'h1',
    'h2',
    'h3',
    'h4',
    'h5',
    'h6',
    'header',
    'hr',
    'i',
    'iframe',
    'img',
    'input',
    'ins',
    'kbd',
    'label',
    'legend',
    'li',
    'main',
    'mark',
    'menu',
    'meter',
    'nav',
    'ol',
    'optgroup',
    'option',
    'output',
    'p',
    'picture',
    'pre',
    'progress',
    'q',
    'rp',
    'rt',
    'ruby',
    's',
    'samp',
    'section',
    'select',
    'small',
    'span',
    'strong',
    'sub',
    'summary',
    'sup',
    'table',
    'tbody',
    'td',
    'tfoot',
    'th',
    'thead',
    'time',
    'tr',
    'track',
    'u',
    'ul',
    'var',
    'video',
    'wbr'
  );

  // -------------------------------------------------------
  // 4. Build final KSES rules (Core style)
  // -------------------------------------------------------
  $kses_tags = array();

  foreach ($allowed_tags as $tag) {

    $kses_tags[$tag] = array();

    // Add global attributes
    foreach ($global_atts as $attr => $enabled) {
      $kses_tags[$tag][$attr] = array();
    }

    // Add tag-specific attributes
    if (isset($tag_specific[$tag])) {
      foreach ($tag_specific[$tag] as $attr => $enabled) {
        $kses_tags[$tag][$attr] = array();
      }
    }
  }

  // -------------------------------------------------------
  // 5. Return sanitized output
  // -------------------------------------------------------
  return function_exists('wp_kses')
    ? wp_kses($raw, $kses_tags)
    : $raw;
}

/** ---------------------------------------------------------------
 * Get Allowed HTML Tags.
 * Allowed levels are basic, intermediate and advance
 *---------------------------------------------------------------*/
function tj_get_allowed_html_desc($level = 'basic')
{
  if (!in_array($level, ['basic', 'intermediate', 'advance'])) {
    $level = 'basic';
  }

  $tags_str = '<' . implode('>,<', array_keys(tj_get_allowed_html_tags($level))) . '>';
  return sprintf(__('This input field has support for the following HTML tags: %1$s', 'tjcore'), '<code>' . esc_html($tags_str) . '</code>');
}

// Get a list of all the allowed html tags.
function tj_get_allowed_html_tags($level = 'basic')
{
  $allowed_html = [
    'b'      => [],
    'i'      => [
      'class' => [],
    ],
    'u'      => [],
    'em'     => [],
    'br'     => [],
    'abbr'   => [
      'title' => [],
    ],
    'span'   => [
      'class' => [],
    ],
    'strong' => [],
  ];

  if ($level === 'intermediate') {
    $allowed_html['a'] = [
      'href'   => [],
      'title'  => [],
      'class'  => [],
      'id'     => [],
      'target' => [],
    ];
  }

  if ($level === 'advance') {
    $allowed_html['ul'] = [
      'class' => [],
      'id'    => [],
    ];
    $allowed_html['ol'] = [
      'class' => [],
      'id'    => [],
    ];
    $allowed_html['li'] = [
      'class' => [],
      'id'    => [],
    ];
    $allowed_html['a'] = [
      'href'   => [],
      'title'  => [],
      'class'  => [],
      'id'     => [],
      'target' => [],
    ];
  }

  return $allowed_html;
}


/** ---------------------------------------------------------------
 * TJ Upload SVG file
 *---------------------------------------------------------------*/
function tj_el_mime_types($mimes)
{
  $mimes['svg'] = 'image/svg+xml';
  $mimes['svgz'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'tj_el_mime_types', 10, 1);

/** ---------------------------------------------------------------
 * TJ Upload SVG for Elementor
 *---------------------------------------------------------------*/
function tj_el_unfiltered_files_upload()
{
  //if exists, assign to $svg_support var
  $svg_support = get_option('elementor_unfiltered_files_upload');

  if (!$svg_support) {
    $svg_support = '1';
    update_option('elementor_unfiltered_files_upload', $svg_support);
  }
}
add_action('elementor/init', 'tj_el_unfiltered_files_upload');

/** ---------------------------------------------------------------
 * TJ Elementor support function
 *---------------------------------------------------------------*/

function tj_el_elementor_option_updated()
{

  // Disable Elementor color schemes
  if (get_option('elementor_disable_color_schemes') !== 'yes') {
    update_option('elementor_disable_color_schemes', 'yes');
  }

  // Disable Elementor typography schemes
  if (get_option('elementor_disable_typography_schemes') !== 'yes') {
    update_option('elementor_disable_typography_schemes', 'yes');
  }

  // Set Elementor SVG Icons Experiment to Inactive
  if (get_option('elementor_experiment-e_font_icon_svg') !== 'inactive') {
    update_option('elementor_experiment-e_font_icon_svg', 'inactive');
  }

  // Set Elementor Container Experiment to Active
  if (get_option('elementor_experiment-container') !== 'active') {
    update_option('elementor_experiment-container', 'active');
  }

  // Support Elementor Custom Post Types (safe version)
  $tj_elmentor_cpt = get_option('elementor_cpt_support', []);

  $tj_required_cpts = ['post', 'page', 'projects', 'services'];

  foreach ($tj_required_cpts as $cpt) {
    if (! in_array($cpt, $tj_elmentor_cpt, true)) {
      $tj_elmentor_cpt[] = $cpt;
    }
  }

  update_option('elementor_cpt_support', $tj_elmentor_cpt);
}

add_action('elementor/init', 'tj_el_elementor_option_updated');
