<?php

/** 
 * This template for projects archive
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */
if (!defined('ABSPATH')) {
  die('Direct access forbidden.');
}

get_header();

$showProjects = get_theme_mod('show_projects_item', -1);

$args = array(
  'post_type' => 'projects',
  'post_status' => 'publish',
  'posts_per_page' => $showProjects,
  'order' => 'DESC',
);

// The Query
$query = new \WP_Query($args);

$project_excerpt = get_theme_mod('project_excerpt', false);
$project_category = get_theme_mod('project_category', true);

?>

<!-- Start: Project Area -->
<section class="tj-project-page section-space">
  <div class="container">
    <?php if ($query->have_posts()) : ?>
      <div class="row rg-30 justify-content-center">

        <?php while ($query->have_posts()) : $query->the_post();

          $categories = get_the_terms(get_the_ID(), 'projects-cat');
        ?>
          <div class="col-xl-4 col-md-6">
            <div class="project-item wow fadeInUp" data-wow-delay="0.1s">
              <?php if (has_post_thumbnail()): ?>
                <div class="project-image">
                  <a class="cursor-hide" href="<?php the_permalink(); ?>">
                    <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
                  </a>
                </div>
              <?php endif; ?>
              <div class="project-content">
                <div class="project-title">
                  <h4 class="title">
                    <a href="<?php the_permalink(); ?>">
                      <?php the_title(); ?>
                      <i class="tji-arrow-right"></i>
                    </a>
                  </h4>
                </div>
                <?php if (get_the_excerpt() && !empty($project_excerpt)): ?>
                  <!-- excerpt -->
                  <div class="desc">
                    <?php echo wp_trim_words(get_the_excerpt(), '15', '...'); ?>
                  </div>
                <?php endif; ?>
                <?php if (!empty($categories) && !empty($project_category)): ?>
                  <div class="tag-list">
                    <?php
                    $category_names = array();
                    foreach ($categories as $cat) {
                      $category_names[] = '<a href="' . esc_url(get_category_link($cat->term_id)) . '">' . esc_html($cat->name) . '</a>';
                    }
                    echo implode(' ', $category_names);
                    ?>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        <?php endwhile;
        wp_reset_query(); ?>

      </div>
    <?php else :
      printf("%s", esc_html__("No projects available!", 'tjcore'));
    endif; ?>
  </div>
</section>
<!-- end: Project Area -->

<?php get_footer(); ?>