<?php

/**
 * TJ Plugin Validation Check
 *
 *
 * @author 		ThemeJunction 
 * @package 	TJCore
 * @version 	1.0.0
 * 
 * Class TJ_Core_Plugin
 */

namespace TJCore;

if (!defined('ABSPATH')) {
	die('Direct access forbidden.');
};



/** ---------------------------------------------------------------
 * Main Plugin class
 *---------------------------------------------------------------*/
class TJ_Core_Plugin {

	private static $_instance = null;

	public static function instance() {
		if (is_null(self::$_instance)) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	/** ---------------------------------------------------------------
	 * Register Custom Category
	 *---------------------------------------------------------------*/
	public function tj_core_elementor_category($elements_manager) {
		$elements_manager->add_category(
			'tjcore',
			[
				'title' => esc_html__('ThemeJunction Addons', 'tjcore'),
				'icon' => 'fa fa-plug',
			],
			1
		);
	}

	/** ---------------------------------------------------------------
	 * Register new Elementor widgets.
	 *---------------------------------------------------------------*/
	public function tj_register_widgets($widgets_manager) {
		// Its is now safe to include Widgets files
		foreach ($this->tjcore_widget_list() as $widget_file_name) {
			require_once(TJCORE_ELEMENTOR_PATH . "/{$widget_file_name}.php");
		}
	}

	public function tjcore_widget_list() {
		return [
			'tj-headers',
			'tj-mega-menu',
			'tj-heading',
			'tj-text',
			'tj-button',
			'tj-sec-title',
			'tj-image',
			'tj-brand-carousel',
			'tj-hero-banner',
			'tj-hero-banner-slider',
			'tj-banner-four',
			'tj-feature',
			'tj-about',
			'tj-about-2',
			'tj-about-4',
			'tj-about-image',
			'tj-counter',
			'tj-counter-2',
			'tj-divider',
			'tj-form',
			'tj-cta',
			'tj-cta-two',
			'tj-cta-three',
			'tj-contact-info',
			'tj-careers',
			'tj-career-form',
			'tj-list',
			'tj-service-title',
			'tj-services',
			'tj-services-list',
			'tj-project-info',
			'tj-projects',
			'tj-projects-grid',
			'tj-projects-2',
			'tj-projects-4',
			'tj-projects-carousel',
			'tj-project-filter',
			'tj-progress-bar',
			'tj-blog-grid',
			'tj-latest-posts',
			'tj-team',
			'tj-testimonial',
			'tj-swiper-navigation',
			'tj-video-info',
			'tj-marquee',
			'tj-pricing-button',
			'tj-pricing-box',
			'tj-accordion',
			'tj-sidebar-cta',
			'tj-navigation',
			'tj-search-form',
			'tj-timeline',
			'tj-rating',
			'tj-process',
			'tj-image-slider',
			'tj-advanced-tab',
			'tj-brands',
			'tj-pricing-tab',
			'tj-blog-carousel',

			'tj-socials',
			'tj-footer-info',
			'tj-footer-contact',
			'tj-footer-menu',
			'tj-footer-navigation',
			'tj-footer-bottom',
			'tj-footer-subscription',

			'tj-coming-soon',
			'tj-gallery'
		];
	}

	/** ---------------------------------------------------------------
	 * TJ Custom Icons
	 *---------------------------------------------------------------*/
	public function tj_custom_icons_tab($tabs = []) {

		// font awesome light
		$tabs['fontawesome-light'] = [
			'name'          => 'fontawesome-light',
			'label'         => esc_html__('TJ Font Awesome - Light', 'tjcore'),
			'labelIcon'     => 'fab fa-font-awesome-alt',
			'prefix'        => 'fa-',
			'displayPrefix' => 'fal',
			'url'           => TJCORE_URL . './inc/icons/font-awesome/css/fontawesome-all.min.css',
			'fetchJson'     => TJCORE_URL . './inc/icons/font-awesome/fonts/font-awesome.json',
			'ver'           => '1.0.0',
		];

		//ThemeJunction Icons
		$tabs['theme-junction-icons'] = [
			'name'          => 'theme-junction-icons',
			'label'         => esc_html__('Theme Junction Icons', 'tjcore'),
			'labelIcon'     => 'eicon-shape',
			'prefix'        => 'tji-',
			'displayPrefix' => 'tj',
			'url'           => TJCORE_URL . 'inc/icons/tj-icons/css/tj-icons.css',
			'fetchJson'     => TJCORE_URL . 'inc/icons/tj-icons/fonts/tj-icons.json',
			'ver'           => '1.0.0',
		];
		return $tabs;
	}

	/** ---------------------------------------------------------------
	 * TJ Editor Enqueue Style
	 *---------------------------------------------------------------*/
	public function tj_editor_enqueue_styles() {
		wp_enqueue_style('tj-element-addons-editor', TJCORE_URL . 'assets/css/editor.css', null, '1.0');
	}

	/** ---------------------------------------------------------------
	 * TJ Editor Enqueue Scripts
	 *---------------------------------------------------------------*/
	public function tj_editor_enqueue_scripts() {
	}

	/** ---------------------------------------------------------------
	 * TJ Frontend Register Scripts
	 *---------------------------------------------------------------*/
	public function tj_frontend_enqueue_scripts() {
		wp_enqueue_script('tj-gallery', TJCORE_URL . 'inc/assets/js/tj-gallery.js', ['elementor-frontend'], TJCORE_VERSION, true);
	}

	/** ---------------------------------------------------------------
	 * TJ Frontend Enqueue Styles
	 *---------------------------------------------------------------*/
	public function tj_frontend_enqueue_styles() {
		wp_enqueue_style('tj-gallery', TJCORE_URL . 'inc/assets/css/tj-gallery.css', ['elementor-frontend'], TJCORE_VERSION);
	}


	/** ---------------------------------------------------------------
	 * Force load editor script as a module
	 *---------------------------------------------------------------*/
	public function editor_scripts_as_a_module($tag, $handle) {
		if ('elementor-hello-world-editor' === $handle) {
			$tag = str_replace('<script', '<script type="module"', $tag);
		}

		return $tag;
	}

	/** ---------------------------------------------------------------
	 * Plugin class constructor
	 * Register plugin action hooks and filters
	 *---------------------------------------------------------------*/
	public function __construct() {
		// Register custom category
		add_action('elementor/elements/categories_registered', [$this, 'tj_core_elementor_category']);

		// Register Elementor New Widgets
		add_action('elementor/widgets/register', [$this, 'tj_register_widgets']);

		// Register custom icons
		add_filter('elementor/icons_manager/additional_tabs', [$this, 'tj_custom_icons_tab']);
		// $this->tj_custom_icons();

		// Enqueue Editor Scripts
		add_action('elementor/editor/after_enqueue_scripts', [$this, 'tj_editor_enqueue_scripts']);

		// Enqueue Editor Styles
		add_action('elementor/editor/before_enqueue_styles', [$this, 'tj_editor_enqueue_styles']);

		// Enqueue Frontend Scripts
		add_action('elementor/frontend/after_enqueue_scripts', [$this, 'tj_frontend_enqueue_scripts']);

		// Enqueue Frontend Styles
		add_action('elementor/frontend/after_enqueue_styles', [$this, 'tj_frontend_enqueue_styles']);
	}
}

// Instantiate Plugin Class
TJ_Core_Plugin::instance();
