<?php

/**
 * Solvior Child Theme functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

if (!defined('WP_DEBUG')) {
   die('Direct access forbidden.');
}

add_action('wp_enqueue_scripts', 'solvior_child_enqueue_styles', 99);

function solvior_child_enqueue_styles()
{
   // enqueue the parent stylesheet
   wp_enqueue_style('parent-style', get_stylesheet_directory_uri() . '/style.css');

   // enqueue the parent RTL stylesheet
   if (is_rtl()) {
      wp_enqueue_style('parent-rtl', get_template_directory_uri() . '/rtl.css');
   }

   // enqueue the child stylesheet
   wp_enqueue_style('child-style', get_stylesheet_uri());
}
