<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

get_header();

$solviorErrorImage = get_theme_mod('error_image', SOLVIOR_ASSETS_IMAGES_URL . '/404.png');
$solviorErrorTitle = get_theme_mod('solvior_error_title', esc_html__('Opps! Page not found', 'solvior'));
$solviorErrorDesc = get_theme_mod('solvior_error_desc', esc_html__('Page does not exist or some other error occurred. Go to our Home Page', 'solvior'));
$solviorErrorBtnText = get_theme_mod('solvior_error_btn_text', esc_html__('Go back to home page', 'solvior'));
?>
<section class="tj-error__area not-found section-space">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col">
				<div class="tj-error__wrap text-center">
					<div class="tj-error__content">
						<?php if (!empty($solviorErrorImage)): ?>
							<div class="error_img mb-20">
								<img src="<?php echo esc_url($solviorErrorImage); ?>" alt="<?php echo esc_attr(get_post_meta(attachment_url_to_postid($solviorErrorImage), '_wp_attachment_image_alt', true)); ?>">
							</div>
						<?php endif; ?>
						<?php if (!empty($solviorErrorTitle)): ?>
							<h2 class="error_title text-anim mb-20"><?php echo esc_html($solviorErrorTitle); ?></h2>
						<?php endif; ?>
						<?php if (!empty($solviorErrorDesc)): ?>
							<div class="error_desc mb-30"><?php echo esc_html($solviorErrorDesc); ?></div>
						<?php endif; ?>
						<?php if (!empty($solviorErrorBtnText)): ?>
							<a href="<?php echo esc_url(home_url('/')); ?>" class="tj-primary-btn">
								<div class="btn_inner">
									<div class="btn_icon">
										<span>
											<i class="tji-arrow-right"></i>
											<i class="tji-arrow-right"></i>
										</span>
									</div>
									<div class="btn_text">
										<span><?php echo esc_html($solviorErrorBtnText); ?></span>
									</div>
								</div>
							</a>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section><!-- .error-404 -->

<?php
get_footer();
