<?php

/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

get_header();

$solviorBlogColumn = is_active_sidebar('blog-sidebar') ? 8 : 12;


if (!function_exists('elementor_theme_do_location') || !elementor_theme_do_location('archive')) { ?>

	<section class="full-width tj-posts__area section-space">
		<div class="container">
			<div class="row rg-50">
				<div class="col-lg-<?php print esc_attr($solviorBlogColumn); ?> ">
					<!-- post container -->
					<div class="tj-post__container tj-post-wrapper">
						<?php if (have_posts()) :

							/* Start the Loop */
							while (have_posts()) : the_post();

								/*
						* Include the Post-Type-specific template for the content.
						* If you want to override this in a child theme, then include a file
						* called content-___.php (where ___ is the Post Type name) and that will be used instead.
						*/
								get_template_part('template-parts/content', get_post_format());

							endwhile;

							// pagination
							global $wp_query;
							$pages = $wp_query->max_num_pages;
							if ($pages > 1) {

								$arrLeft = '<i class="tji-arrow-left"></i>';
								$arrRight = '<i class="tji-arrow-right"></i>';
								$prev_icon = is_rtl() ? ' ' . $arrRight . ' ' : '' . $arrLeft . '';
								$next_icon = is_rtl() ? ' ' . $arrLeft . ' ' : ' ' . $arrRight . ' ';
						?>
								<div class="tj-pagination">
									<?php solvior_pagination($prev_icon, $next_icon, '', ['class' => '']); ?>
								</div>
						<?php	};
						else :
							get_template_part('template-parts/content', 'none');
						endif; ?>

					</div>
					<!-- !post container -->
				</div>

				<?php if (is_active_sidebar('blog-sidebar')) : ?>
					<!-- sidebar -->
					<div class="col-lg-4">
						<aside class="tj-main__sidebar tj-post-sidebar">
							<?php get_sidebar(); ?>
						</aside>
					</div>
					<!--!sidebar -->
				<?php endif; ?>
			</div>
		</div>
	</section>

<?php
}
get_footer();
