<?php

/**
 * Solvior Theme functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

/**
 *---------------------------------------------------------------------------------------
 * Define constants
 *---------------------------------------------------------------------------------------
 */
define('SOLVIOR_THEME_NAME', 'Solvior');
define('SOLVIOR_THEME_SLUG', 'solvior');

define('SOLVIOR_THEME_VERSION', '1.1.7');

define('SOLVIOR_THEME_DIR', get_template_directory());
define('SOLVIOR_THEME_URL', get_template_directory_uri());
define('SOLVIOR_STYLESHEET_URL', get_stylesheet_uri());

define('SOLVIOR_INC_DIR', SOLVIOR_THEME_DIR . '/inc');
define('SOLVIOR_INC_URL', SOLVIOR_THEME_URL . '/inc');

define('SOLVIOR_COMMON_DIR', SOLVIOR_THEME_DIR . '/inc/common');
define('SOLVIOR_COMMON_URL', SOLVIOR_THEME_URL . '/inc/common');

define('SOLVIOR_CUSTOMIZER_DIR', SOLVIOR_INC_DIR . '/customizer/');

define('SOLVIOR_TEMPLATE_PARTS', SOLVIOR_THEME_DIR . '/template-parts/');

define('SOLVIOR_ASSETS_DIR', SOLVIOR_THEME_DIR . '/assets');
define('SOLVIOR_ASSETS_URL', SOLVIOR_THEME_URL . '/assets');

define('SOLVIOR_ASSETS_CSS_DIR', SOLVIOR_THEME_DIR . '/assets/css/');
define('SOLVIOR_ASSETS_CSS_URL', SOLVIOR_THEME_URL . '/assets/css/');

define('SOLVIOR_ASSETS_JS_DIR', SOLVIOR_THEME_DIR . '/assets/js/');
define('SOLVIOR_ASSETS_JS_URL', SOLVIOR_THEME_URL . '/assets/js/');

define('SOLVIOR_ASSETS_IMAGES_DIR', SOLVIOR_THEME_DIR . '/assets/images');
define('SOLVIOR_ASSETS_IMAGES_URL', SOLVIOR_THEME_URL . '/assets/images');

/**
 * ---------------------------------------------------------------------------------------
 * Template Hooks
 * ---------------------------------------------------------------------------------------
 */
require_once SOLVIOR_INC_DIR . '/template-hooks.php';

/**
 * ---------------------------------------------------------------------------------------
 * Template Helpers
 * ---------------------------------------------------------------------------------------
 */
require_once SOLVIOR_INC_DIR . '/template-helpers.php';

/**
 * ---------------------------------------------------------------------------------------
 * TGM Include
 * ---------------------------------------------------------------------------------------
 */
require_once SOLVIOR_INC_DIR . '/lib/class-tgm-plugin-activation.php';
require_once SOLVIOR_INC_DIR . '/lib/tgm-config.php';

/**
 * ---------------------------------------------------------------------------------------
 * Theme Customizer
 * ---------------------------------------------------------------------------------------
 */
require_once SOLVIOR_INC_DIR . '/lib/class-kirki-customizer.php';
require_once SOLVIOR_CUSTOMIZER_DIR . 'customizer-config.php';

/**
 * ---------------------------------------------------------------------------------------
 * Include Files
 * ---------------------------------------------------------------------------------------
 */
require_once SOLVIOR_INC_DIR . '/template-functions.php';

require_once SOLVIOR_INC_DIR . '/lib/class-navwalker.php';

if (defined('JETPACK__VERSION')) {
  require_once SOLVIOR_INC_DIR . '/jetpack.php';
}

/**
 * ---------------------------------------------------------------------------------------
 * WooCommerce Include
 * ---------------------------------------------------------------------------------------
 */
if (class_exists('WooCommerce')) {
  require SOLVIOR_INC_DIR . '/lib/woocommerce.php';
}
