<?php

/**
 * Solvior Theme Scripts
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

if (!defined('ABSPATH')) {
  exit;
}


function solvior_scripts()
{
  /**
   * ---------------------------------------------------------------------------------------
   * Enqueue All CSS Files
   * ---------------------------------------------------------------------------------------
   */
  wp_enqueue_style('solvior-google-fonts', solvior_google_fonts_url(), '', null);

  if (is_rtl()) {
    wp_enqueue_style('tj-bootstrap-rtl', SOLVIOR_ASSETS_CSS_URL . 'bootstrap.rtl.min.css', []);
  } else {
    wp_enqueue_style('tj-bootstrap', SOLVIOR_ASSETS_CSS_URL . 'bootstrap.min.css', []);
  }
  wp_enqueue_style('font-awesome-pro', SOLVIOR_ASSETS_CSS_URL . 'font-awesome-pro.min.css', []);
  wp_enqueue_style('tj-animate', SOLVIOR_ASSETS_CSS_URL . 'animate.css', []);
  wp_enqueue_style('tj-nice-select', SOLVIOR_ASSETS_CSS_URL . 'nice-select.css', []);
  wp_enqueue_style('tj-mean-menu', SOLVIOR_ASSETS_CSS_URL . 'mean-menu.css', []);
  wp_enqueue_style('tj-odometer', SOLVIOR_ASSETS_CSS_URL . 'odometer.css', []);
  wp_enqueue_style('tj-swiper-min', SOLVIOR_ASSETS_CSS_URL . 'swiper.min.css', []);
  wp_enqueue_style('tj-venobox-min', SOLVIOR_ASSETS_CSS_URL . 'venobox.min.css', []);
  wp_enqueue_style('tj-solvior-icons', SOLVIOR_ASSETS_CSS_URL . 'solvior-icons.css', []);
  wp_enqueue_style('tj-solvior-core', SOLVIOR_ASSETS_CSS_URL . 'solvior-core.css', [], SOLVIOR_THEME_VERSION);
  wp_enqueue_style('tj-solvior-unit', SOLVIOR_ASSETS_CSS_URL . 'solvior-unit.css', [], SOLVIOR_THEME_VERSION);

  if (class_exists('WooCommerce')) {
    wp_enqueue_style('tj-solvior-shop', SOLVIOR_ASSETS_CSS_URL . 'solvior-shop.css', [], SOLVIOR_THEME_VERSION);
  }

  wp_enqueue_style('solvior-style', get_stylesheet_uri(), [], SOLVIOR_THEME_VERSION);

  /**
   * ---------------------------------------------------------------------------------------
   * Enqueue All JS Files
   * ---------------------------------------------------------------------------------------
   */
  wp_enqueue_script('tj-bootstrap', SOLVIOR_ASSETS_JS_URL . 'bootstrap.bundle.min.js', ['jquery'], '', true);
  wp_enqueue_script('tj-gsap-min', SOLVIOR_ASSETS_JS_URL . 'gsap.min.js', ['jquery'], '', true);
  wp_enqueue_script('tj-scroll-to-plugin', SOLVIOR_ASSETS_JS_URL . 'scroll-to-plugin.min.js', ['jquery'], '', true);
  wp_enqueue_script('tj-gsap-scroll-trigger', SOLVIOR_ASSETS_JS_URL . 'gsap-scroll-trigger.min.js', ['jquery'], '', true);
  wp_enqueue_script('tj-gsap-split-text', SOLVIOR_ASSETS_JS_URL . 'gsap-split-text.min.js', ['jquery'], '', true);
  wp_enqueue_script('tj-smooth-scroll', SOLVIOR_ASSETS_JS_URL . 'smooth-scroll.min.js', ['jquery'], '', true);

  wp_enqueue_script('tj-appear-min', SOLVIOR_ASSETS_JS_URL . 'appear.min.js', ['jquery'], '', true);
  wp_enqueue_script('tj-wow-min', SOLVIOR_ASSETS_JS_URL . 'wow.min.js', ['jquery'], '', true);
  wp_enqueue_script('tj-nice-select', SOLVIOR_ASSETS_JS_URL . 'nice-select.js', ['jquery'], '', true);
  wp_enqueue_script('tj-meanmenu', SOLVIOR_ASSETS_JS_URL . 'meanmenu.js', ['jquery'], '', true);
  wp_enqueue_script('tj-odometer', SOLVIOR_ASSETS_JS_URL . 'odometer.min.js', ['jquery'], '', true);
  wp_enqueue_script('tj-solvior-knob', SOLVIOR_ASSETS_JS_URL . 'solvior-knob.js', ['jquery'], '', true);
  wp_enqueue_script('tj-swiper-min', SOLVIOR_ASSETS_JS_URL . 'swiper.min.js', ['jquery'], '', true);
  wp_enqueue_script('tj-venobox-min', SOLVIOR_ASSETS_JS_URL . 'venobox.min.js', ['jquery'], '', true);
  wp_enqueue_script('tj-chart-min', SOLVIOR_ASSETS_JS_URL . 'chart.min.js', ['jquery'], '', true);
  wp_enqueue_script('tj-purecounter', SOLVIOR_ASSETS_JS_URL . 'purecounter.js', ['jquery'], '', true);
  wp_enqueue_script('tj-isotope', SOLVIOR_ASSETS_JS_URL . 'isotope.pkgd.min.js', ['jquery', 'imagesloaded'], '', true);
  wp_enqueue_script('tj-solvior-core', SOLVIOR_ASSETS_JS_URL . 'solvior-core.js', ['jquery'], SOLVIOR_THEME_VERSION, true);

  if (is_singular() && comments_open() && get_option('thread_comments')) {
    wp_enqueue_script('comment-reply');
  }
}
add_action('wp_enqueue_scripts', 'solvior_scripts');

/**
 * ---------------------------------------------------------------------------------------
 * Register Google Fonts
 * ---------------------------------------------------------------------------------------
 */
function solvior_google_fonts_url()
{
  $fonts_url     = '';
  $font_families = [];

  $Lato       = _x('on', 'Lato font: on or off', 'solvior');
  $LibreFranklin = _x('on', 'Libre Franklin font: on or off', 'solvior');

  if ('off' !== $LibreFranklin) {
    $font_families[] = 'Libre Franklin:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap';
  }
  if ('off' !== $Lato) {
    $font_families[] = 'Lato:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap';
  }

  if ($font_families) {
    $query_args = array(
      'family' => urlencode(implode('|', $font_families)),
      'subset' => urlencode('latin,latin-ext'),
    );
    $fonts_url = add_query_arg($query_args, '//fonts.googleapis.com/css');
  }

  return $fonts_url;
}
