<?php

/**
 * Solvior Theme Widgets Register
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

if (!defined('ABSPATH')) {
  exit;
}

/**
 *    ---------------------------------------------------------------------------------------
 *    Register widget area.
 *    ---------------------------------------------------------------------------------------
 */

/**
 * blog sidebar
 */
register_sidebar([
  'name'          => esc_html__('Blog Sidebar', 'solvior'),
  'id'            => 'blog-sidebar',
  'before_widget' => '<div id="%1$s" class="tj-sidebar__widget tj-sidebar-widget %2$s">',
  'after_widget'  => '</div>',
  'before_title'  => '<h5 class="tj-sidebar-widget-title">',
  'after_title'   => '</h5>',
]);

$solviorFooterColumns = get_theme_mod('footer_widget_column', 4);

// footer default
for ($num = 1; $num <= $solviorFooterColumns; $num++) {
  register_sidebar([
    'name'          => sprintf(esc_html__('Footer Column %1$s', 'solvior'), $num),
    'id'            => 'footer-' . $num,
    'description'   => sprintf(esc_html__('This widget content will be show widget %1$s', 'solvior'), $num),
    'before_widget' => '<div id="%1$s" class="tj-footer__widget footer-widget footer-column__' . $num . ' %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<div class="footer-title"><h4 class="title">',
    'after_title'   => '</h4></div>',
  ]);
}
