<?php

/**
 * Solvior Customizer Configuration
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

if (!defined('ABSPATH')) {
  exit;
}

// Do not proceed if Kirki does not exist.
if (!class_exists('Kirki')) {
  return;
}

class Solvior_Customizer
{

  public static $_instance;

  public function __construct()
  {
    add_action('customize_register', [$this, 'solvior_customizer_sections']);
    add_filter('kirki/fields', [$this, 'solvior_customizer_setting']);
    add_action('customize_preview_init', [$this, 'solvior_customize_preview_js']);
  }

  /**
   *    ---------------------------------------------------------------------------------------
   *    Customizer Sections
   *    ---------------------------------------------------------------------------------------
   */
  public function solvior_customizer_sections($wp_customize)
  {
    // Customizer Panel
    $wp_customize->add_panel('solvior_customizer_panel', [
      'priority' => 10,
      'title'    => esc_html__('Solvior Customizer', 'solvior'),
    ]);

    // general settings
    $wp_customize->add_section('general_settings', [
      'title'       => esc_html__('General Settings', 'solvior'),
      'priority'    => 1,
      'description' => esc_html__('To change site general settings and google map api.', 'solvior'),
      'panel'       => 'solvior_customizer_panel',
    ]);

    // typography settings
    $wp_customize->add_section('typo_settings', [
      'title'       => esc_html__('Typography Settings', 'solvior'),
      'priority'    => 2,
      'description' => esc_html__('Setup site typography settings.', 'solvior'),
      'panel'       => 'solvior_customizer_panel',
    ]);

    // colors settings
    $wp_customize->add_section('colors_settings', [
      'title'       => esc_html__('Color Settings', 'solvior'),
      'priority'    => 3,
      'description' => esc_html__('Setup site color settings.', 'solvior'),
      'panel'       => 'solvior_customizer_panel',
    ]);

    // Logos
    $wp_customize->add_section('solvior_theme_logos', [
      'title'       => esc_html__('Site Logos', 'solvior'),
      'description' => esc_html__('Setup site logos.', 'solvior'),
      'priority'    => 4,
      'capability'  => 'edit_theme_options',
      'panel'       => 'solvior_customizer_panel',
    ]);

    // Contact Infos
    $wp_customize->add_section('solvior_contact_infos', [
      'title'       => esc_html__('Contact Info', 'solvior'),
      'description' => esc_html__('Setup site contact infos.', 'solvior'),
      'priority'    => 5,
      'panel'       => 'solvior_customizer_panel',
    ]);

    // header settings
    $wp_customize->add_section('header_settings', [
      'title'       => esc_html__('Header Settings', 'solvior'),
      'priority'    => 6,
      'description' => esc_html__('Setup site header settings.', 'solvior'),
      'panel'       => 'solvior_customizer_panel',
    ]);

    // mobile menu
    $wp_customize->add_section('solvior_mobile_menu', [
      'title'       => esc_html__('Mobile Menu', 'solvior'),
      'description' => esc_html__('Setup site mobile menu infos.', 'solvior'),
      'priority'    => 7,
      'panel'       => 'solvior_customizer_panel',
    ]);

    // Breadcrumb Settings
    $wp_customize->add_section('breadcrumb_setting', [
      'title'       => esc_html__('Breadcrumb Setting', 'solvior'),
      'priority'    => 8,
      'description' => esc_html__('Setup site breadcrumb settings.', 'solvior'),
      'panel'       => 'solvior_customizer_panel',
    ]);

    // blog settings
    $wp_customize->add_section('blog_settings', [
      'title'       => esc_html__('Blog Settings', 'solvior'),
      'priority'    => 9,
      'description' => esc_html__('Setup blog pages settings.', 'solvior'),
      'panel'       => 'solvior_customizer_panel',
    ]);

    // Services settings
    $wp_customize->add_section('services_settings', [
      'title'       => esc_html__('Services Settings', 'solvior'),
      'priority'    => 10,
      'description' => esc_html__('Setup services pages settings.', 'solvior'),
      'panel'       => 'solvior_customizer_panel',
    ]);

    // Projects settings
    $wp_customize->add_section('projects_settings', [
      'title'       => esc_html__('Projects Settings', 'solvior'),
      'priority'    => 11,
      'description' => esc_html__('Setup projects pages settings.', 'solvior'),
      'panel'       => 'solvior_customizer_panel',
    ]);

    // footer settings
    $wp_customize->add_section('footer_settings', [
      'title'       => esc_html__('Footer Settings', 'solvior'),
      'priority'    => 12,
      'description' => esc_html__('Setup site footer settings.', 'solvior'),
      'panel'       => 'solvior_customizer_panel',
    ]);

    // permalink settings
    $wp_customize->add_section('permalink_settings', [
      'title'       => esc_html__('Permalink Settings', 'solvior'),
      'priority'    => 13,
      'description' => esc_html__('Setup site permalink settings.', 'solvior'),
      'panel'       => 'solvior_customizer_panel',
    ]);

    // 404 page settings
    $wp_customize->add_section('404_page', [
      'title'       => esc_html__('404 Page', 'solvior'),
      'priority'    => 14,
      'description' => esc_html__('Setup 404 page settings.', 'solvior'),
      'panel'       => 'solvior_customizer_panel',
    ]);

    // shop page settings
    $wp_customize->add_section('shop_page', [
      'title'       => esc_html__('Shop Page', 'solvior'),
      'priority'    => 14,
      'description' => esc_html__('Setup Shop page settings.', 'solvior'),
      'panel'       => 'solvior_customizer_panel',
    ]);
  }

  /**
   *    ---------------------------------------------------------------------------------------
   *    Customizer Settings Fields
   *    ---------------------------------------------------------------------------------------
   */
  public function solvior_customizer_setting($fields)
  {

    require SOLVIOR_CUSTOMIZER_DIR . 'fields/general-settings.php';
    require SOLVIOR_CUSTOMIZER_DIR . 'fields/typography-settings.php';
    require SOLVIOR_CUSTOMIZER_DIR . 'fields/colors-settings.php';
    require SOLVIOR_CUSTOMIZER_DIR . 'fields/theme-logos.php';
    require SOLVIOR_CUSTOMIZER_DIR . 'fields/contact-infos.php';
    require SOLVIOR_CUSTOMIZER_DIR . 'fields/header-settings.php';
    require SOLVIOR_CUSTOMIZER_DIR . 'fields/mobile-menu.php';
    require SOLVIOR_CUSTOMIZER_DIR . 'fields/breadcrumb-settings.php';
    require SOLVIOR_CUSTOMIZER_DIR . 'fields/blog-settings.php';
    require SOLVIOR_CUSTOMIZER_DIR . 'fields/services-settings.php';
    require SOLVIOR_CUSTOMIZER_DIR . 'fields/projects-settings.php';
    require SOLVIOR_CUSTOMIZER_DIR . 'fields/footer-settings.php';
    require SOLVIOR_CUSTOMIZER_DIR . 'fields/permalink-settings.php';
    require SOLVIOR_CUSTOMIZER_DIR . 'fields/404-settings.php';

    if (class_exists('WooCommerce')) {
      require SOLVIOR_CUSTOMIZER_DIR . 'fields/shop-settings.php';
    }

    return $fields;
  }

  /**
   *    ---------------------------------------------------------------------------------------
   *    Customizer Preview JS
   *    ---------------------------------------------------------------------------------------
   */
  public function solvior_customize_preview_js()
  {
    wp_enqueue_script('solvior-customizer', SOLVIOR_INC_URL . '/assets/js/customize-preview.js', array('customize-preview'), SOLVIOR_THEME_VERSION, true);
  }

  public static function solvior_get_instance()
  {
    if (!isset(self::$_instance)) {
      self::$_instance = new Solvior_Customizer();
    }
    return self::$_instance;
  }
}
$solvior_Fields = Solvior_Customizer::solvior_get_instance();
