<?php

/**
 * Customizer Blog Settings
 *
 * style for theme blogs
 */

$fields[] = [
  'type'     => 'custom',
  'settings' => 'blog_custom_01',
  'label'    => FALSE,
  'section'  => 'blog_settings',
  'default'  => '<div class="customizer_label">' . esc_html__('Blog Page Settings', 'solvior') . '</div>',
];
// breadcrumb title
$fields[] = [
  'type'     => 'text',
  'settings' => 'blog_breadcrumb_title',
  'label'    => esc_html__('Blog Breadcrumb Title', 'solvior'),
  'section'  => 'blog_settings',
  'default'  => esc_html__('Blog', 'solvior'),
];
// blog breadcrumb image
$fields[] = [
  'type'        => 'image',
  'settings'    => 'blog_breadcrumb_img',
  'label'       => esc_html__('Blog Breadcrumb Image', 'solvior'),
  'section'     => 'blog_settings',
];
// Blog button
$fields[] = [
  'type'     => 'switch',
  'settings' => 'show_blog_btn',
  'label'    => esc_html__('BTN On/Off', 'solvior'),
  'section'  => 'blog_settings',
  'default'  => '1',
  'choices'  => [
    'on'  => esc_html__('Enable', 'solvior'),
    'off' => esc_html__('Disable', 'solvior'),
  ],
];
// button text
$fields[] = [
  'type'     => 'text',
  'settings' => 'blog_btn_text',
  'label'    => esc_html__('Button text', 'solvior'),
  'section'  => 'blog_settings',
  'default'  => esc_html__('Read More', 'solvior'),
  'active_callback' => [
    [
      'setting'  => 'show_blog_btn',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];

// category meta
$fields[] = [
  'type'     => 'switch',
  'settings' => 'solvior_blog_category',
  'label'    => esc_html__('Category Meta On/Off', 'solvior'),
  'section'  => 'blog_settings',
  'default'  => '1',
  'choices'  => [
    'on'  => esc_html__('Enable', 'solvior'),
    'off' => esc_html__('Disable', 'solvior'),
  ],
];
// date meta
$fields[] = [
  'type'     => 'switch',
  'settings' => 'solvior_blog_date',
  'label'    => esc_html__('Date Meta On/Off', 'solvior'),
  'section'  => 'blog_settings',
  'default'  => '1',
  'choices'  => [
    'on'  => esc_html__('Enable', 'solvior'),
    'off' => esc_html__('Disable', 'solvior'),
  ],
];
// comment meta
$fields[] = [
  'type'     => 'switch',
  'settings' => 'solvior_blog_comments',
  'label'    => esc_html__('Comments Meta On/Off', 'solvior'),
  'section'  => 'blog_settings',
  'default'  => '1',
  'choices'  => [
    'on'  => esc_html__('Enable', 'solvior'),
    'off' => esc_html__('Disable', 'solvior'),
  ],
];
// blog details
$fields[] = [
  'type'     => 'custom',
  'settings' => 'blog_custom_02',
  'label'    => FALSE,
  'section'  => 'blog_settings',
  'default'  => '<div class="customizer_label mt-25">' . esc_html__('Blog Details Page', 'solvior') . '</div>',
];
// blog details breadcrumb title
$fields[] = [
  'type'     => 'text',
  'settings' => 'blog_details_breadcrumb_title',
  'label'    => esc_html__('Blog Details Breadcrumb Title', 'solvior'),
  'section'  => 'blog_settings',
];
// blog details breadcrumb image
$fields[] = [
  'type'        => 'image',
  'settings'    => 'blog_details_breadcrumb_img',
  'label'       => esc_html__('Blog Details Breadcrumb Image', 'solvior'),
  'section'     => 'blog_settings',
];

// single author meta
$fields[] = [
  'type'     => 'switch',
  'settings' => 'solvior_blog_single_author',
  'label'    => esc_html__('Author Meta On/Off', 'solvior'),
  'section'  => 'blog_settings',
  'default'  => '1',
  'choices'  => [
    'on'  => esc_html__('Enable', 'solvior'),
    'off' => esc_html__('Disable', 'solvior'),
  ],
];
$fields[] = [
  'type'     => 'text',
  'settings' => 'solvior_blog_single_author_label',
  'section'  => 'blog_settings',
  'label'    => esc_html__('Author Label', 'solvior'),
  'default'    => esc_html__('Authored by', 'solvior'),
  'active_callback' => [
    [
      'setting'  => 'solvior_blog_single_author',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
// single date meta
$fields[] = [
  'type'     => 'switch',
  'settings' => 'solvior_blog_single_date',
  'label'    => esc_html__('Date Meta On/Off', 'solvior'),
  'section'  => 'blog_settings',
  'default'  => '1',
  'choices'  => [
    'on'  => esc_html__('Enable', 'solvior'),
    'off' => esc_html__('Disable', 'solvior'),
  ],
];
$fields[] = [
  'type'     => 'text',
  'settings' => 'solvior_blog_single_date_label',
  'section'  => 'blog_settings',
  'label'    => esc_html__('Author Label', 'solvior'),
  'default'    => esc_html__('Date Released', 'solvior'),
  'active_callback' => [
    [
      'setting'  => 'solvior_blog_single_date',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
// single comment meta
$fields[] = [
  'type'     => 'switch',
  'settings' => 'solvior_blog_single_comments',
  'label'    => esc_html__('Comments Meta On/Off', 'solvior'),
  'section'  => 'blog_settings',
  'default'  => '1',
  'choices'  => [
    'on'  => esc_html__('Enable', 'solvior'),
    'off' => esc_html__('Disable', 'solvior'),
  ],
];
$fields[] = [
  'type'     => 'text',
  'settings' => 'solvior_blog_single_comments_label',
  'section'  => 'blog_settings',
  'label'    => esc_html__('Author Label', 'solvior'),
  'default'    => esc_html__('Comments', 'solvior'),
  'active_callback' => [
    [
      'setting'  => 'solvior_blog_single_comments',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];

// blog social share
$fields[] = [
  'type'     => 'switch',
  'settings' => 'solvior_blog_socials',
  'label'    => esc_html__('Blog Socials Share On/Off', 'solvior'),
  'section'  => 'blog_settings',
  'default'  => '0',
  'choices'  => [
    'on'  => esc_html__('Enable', 'solvior'),
    'off' => esc_html__('Disable', 'solvior'),
  ],
];
