<?php

/**
 * Customizer Breadcrumb Settings
 *
 * style for theme breadcrumb style
 */

$fields[] = [
  'type'     => 'custom',
  'settings' => 'header_custom_01',
  'label'    => FALSE,
  'section'  => 'breadcrumb_setting',
  'default'  => '<div class="customizer_label">' . esc_html__('Breadcrumb Settings', 'solvior') . '</div>',
];
// navigation info
$fields[] = [
  'type'     => 'toggle',
  'settings' => 'show_breadcrumb',
  'label'    => esc_html__('Show breadcrumb?', 'solvior'),
  'section'  => 'breadcrumb_setting',
  'default'  => '1',
];
// background image
$fields[] = [
  'type'        => 'image',
  'settings'    => 'breadcrumb_bg_img',
  'label'       => esc_html__('Background Image', 'solvior'),
  'section'     => 'breadcrumb_setting',
  'default'     => SOLVIOR_ASSETS_IMAGES_URL . '/pheader-bg.webp',
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];
// background color
$fields[] = [
  'type'        => 'color',
  'settings'    => 'breadcrumb_bg_color',
  'label'       => __('Background Color', 'solvior'),
  'section'     => 'breadcrumb_setting',
  'output'      => [
    [
      'element'  => '.tj-page-header',
      'property' => 'background-color',
    ],
  ],
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];
// overlay color
$fields[] = [
  'type'        => 'color',
  'settings'    => 'breadcrumb_bg_overlay_color',
  'label'       => __('Background Overlay Color', 'solvior'),
  'section'     => 'breadcrumb_setting',
  'transport'   => 'auto',
  'choices'     => [
    'alpha' => true,
  ],
  'output'      => [
    [
      'element'  => '.tj-page-header::before',
      'property' => 'background-color',
    ],
  ],
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];

// breadcrumb navigation
$fields[] = [
  'type'     => 'toggle',
  'settings' => 'breadcrumb_navigation_switch',
  'label'    => esc_html__('Breadcrumb Navigation on/off?', 'solvior'),
  'section'  => 'breadcrumb_setting',
  'default'  => '1',
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];
// Parent title
$fields[] = [
  'type'            => 'text',
  'settings'        => 'breadcrumb_parent_title',
  'label'           => esc_html__('Parent Title', 'solvior'),
  'section'         => 'breadcrumb_setting',
  'default'         => esc_html__('Home', 'solvior'),
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
    [
      'setting'  => 'breadcrumb_navigation_switch',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];
$fields[] = [
  'type'            => 'text',
  'settings'        => 'breadcrumb_word_count',
  'label'           => esc_html__('Word Count', 'solvior'),
  'section'         => 'breadcrumb_setting',
  'default'         => esc_html__('4', 'solvior'),
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
    [
      'setting'  => 'breadcrumb_navigation_switch',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];

$fields[] = [
  'type'        => 'color',
  'settings'    => 'breadcrumb_tile_color',
  'label'       => __('Title Color', 'solvior'),
  'section'     => 'breadcrumb_setting',
  'transport'   => 'auto',
  'choices'     => [
    'alpha' => true,
  ],
  'output'      => [
    [
      'element'  => '.tj-page-title',
      'property' => 'color',
    ],
  ],
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];

$fields[] = [
  'type'        => 'color',
  'settings'    => 'breadcrumb_menu_bg_color',
  'label'       => __('Nav Bg Color', 'solvior'),
  'section'     => 'breadcrumb_setting',
  'transport'   => 'auto',
  'choices'     => [
    'alpha' => true,
  ],
  'output'      => [
    [
      'element'  => '.tj-page-link',
      'property' => 'background',
    ],
  ],
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];

$fields[] = [
  'type'        => 'color',
  'settings'    => 'breadcrumb_menu_item_color',
  'label'       => __('Nav Item Color', 'solvior'),
  'section'     => 'breadcrumb_setting',
  'transport'   => 'auto',
  'choices'     => [
    'alpha' => true,
  ],
  'output'      => [
    [
      'element'  => '.tj-page-link, .tj-page-link span',
      'property' => 'color',
    ],
  ],
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];

$fields[] = [
  'type'     => 'toggle',
  'settings' => 'breadcrumb_title_animation',
  'label'    => esc_html__('Enable Title Animation', 'solvior'),
  'section'  => 'breadcrumb_setting',
  'default'  => true,
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];

$fields[] = [
  'type'     => 'toggle',
  'settings' => 'breadcrumb_space',
  'label'    => esc_html__('Transparent Header Space?', 'solvior'),
  'section'  => 'breadcrumb_setting',
  'default'  => '0',
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];

$fields[] = [
  'type'     => 'dimensions',
  'settings' => 'breadcrumb_padding',
  'section'  => 'breadcrumb_setting',
  'transport'   => 'auto',
  'responsive' => true,
  'default'     => [
    'desktop' => [
      'padding-top'  => '',
      'padding-bottom' => '',
    ],
    'tablet'  => [
      'padding-top'  => '',
      'padding-bottom' => '',
    ],
    'mobile'  => [
      'padding-top'  => '',
      'padding-bottom' => '',
    ],
  ],
  'choices'     => [
    'labels' => [
      'padding-top'  => esc_html__('Padding Top', 'solvior'),
      'padding-bottom' => esc_html__('Padding Bottom', 'solvior'),
    ],
  ],
  'output'      => [
    [
      'choice'   => 'padding-top',
      'element'  => '.tj-page-header.pheader-space, .tj-page-header.pheader-space-2',
      'property' => 'padding-top',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
    [
      'choice'   => 'padding-bottom',
      'element'  => '.tj-page-header.pheader-space, .tj-page-header.pheader-space-2',
      'property' => 'padding-bottom',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
  ],
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];
