<?php

/**
 * Customizer Footer Settings
 *
 * style for theme footer
 */

$footers = Kirki_Helper::get_posts([
  'post_type'      => 'tj-footer-builder',
  'post_status'    => 'publish',
  'posts_per_page' => -1,
  'orderby'        => 'title',
  'order'          => 'ASC',
]);

// select footers
$fields[] = [
  'type'     => 'custom',
  'settings' => 'footer_custom_01',
  'label'    => FALSE,
  'section'  => 'footer_settings',
  'default'  => '<div class="customizer_label">' . esc_html__('Select Footers', 'solvior') . '</div>',
];
$fields[] = [
  'type'     => 'select',
  'settings' => 'select_footers',
  'section'  => 'footer_settings',
  'default'  => 'default',
  'choices'  => [
    'default' => esc_html__('Default Footers', 'solvior'),
    'elementor'  => esc_html__('Elementor Footers', 'solvior'),
  ],
];

// Elementor Footers
if (!empty($footers)) :
  $fields[] = [
    'type'            => 'custom',
    'settings'        => 'footer_custom_02',
    'label'           => FALSE,
    'section'         => 'footer_settings',
    'default'         => '<div class="customizer_label mt-25">' . esc_html__('Choose Elementor Style', 'solvior') . '</div>',
    'active_callback' => [
      [
        'setting'  => 'select_footers',
        'operator' => '==',
        'value'    => 'elementor',
      ],
    ],
  ];
  $fields[] = [
    'type'            => 'select',
    'settings'        => 'elementor_footer_style',
    'label'           => esc_html__('Elementor Footer (LTR)', 'solvior'),
    'section'         => 'footer_settings',
    'choices'         => $footers,
    'default'         => 'footer-1',
    'active_callback' => [
      [
        'setting'  => 'select_footers',
        'operator' => '==',
        'value'    => 'elementor',
      ],
    ],
  ];
  $fields[] = [
    'type'            => 'select',
    'settings'        => 'elementor_footer_style_rtl',
    'label'           => esc_html__('Elementor Footer (RTL)', 'solvior'),
    'section'         => 'footer_settings',
    'choices'         => $footers,
    'default'         => '',
    'active_callback' => [
      [
        'setting'  => 'select_footers',
        'operator' => '==',
        'value'    => 'elementor',
      ],
    ],
  ];
else :
  $fields[] = [
    'type'            => 'custom',
    'settings'        => 'footer_custom_02',
    'label'           => FALSE,
    'section'         => 'footer_settings',
    'default'         => '<div class="alert alert-warning" role="alert">' . esc_html__('No Footers Found! — set elementor footer {Appearance -> TJ Footer Builder}', 'solvior') . '</div>',
    'active_callback' => [
      [
        'setting'  => 'select_footers',
        'operator' => '==',
        'value'    => 'elementor',
      ],
    ],
  ];
endif;

// Footer Settings
$fields[] = [
  'type'            => 'custom',
  'settings'        => 'footer_custom_04',
  'label'           => FALSE,
  'section'         => 'footer_settings',
  'default'         => '<div class="customizer_label mt-25">' . esc_html__('Footer Settings', 'solvior') . '</div>',
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
// Footer Column
$fields[] = [
  'type'            => 'select',
  'settings'        => 'footer_widget_column',
  'label'           => esc_html__('Widget Column', 'solvior'),
  'section'         => 'footer_settings',
  'default'         => '4',
  'placeholder'     => esc_html__('Select an option...', 'solvior'),
  'multiple'        => 1,
  'choices'         => [
    '4' => esc_html__('Column 4', 'solvior'),
    '3' => esc_html__('Column 3', 'solvior'),
    '2' => esc_html__('Column 2', 'solvior'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
// footer bg image
$fields[] = [
  'type'            => 'image',
  'settings'        => 'footer_bg_img',
  'label'           => esc_html__('Background Image', 'solvior'),
  'section'         => 'footer_settings',
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];

// footer bg color
$fields[] = [
  'type'            => 'color',
  'settings'        => 'footer_bg_color',
  'label'           => esc_html__('Background Color', 'solvior'),
  'description'     => esc_html__('This color will be show footer background.', 'solvior'),
  'section'         => 'footer_settings',
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];

// copyright text
$fields[] = [
  'type'            => 'textarea',
  'settings'        => 'solvior_copyright',
  'label'           => esc_html__('Copyright Text', 'solvior'),
  'section'         => 'footer_settings',
  'default'         => solvior_kses('&copy; Copyright 2025 <a href="#">Solvior</a> All Rights Reserved.'),
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];

// footer menu switcher
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'footer_menu_switcher',
  'label'           => esc_html__('Footer Bottom Menu', 'solvior'),
  'section'         => 'footer_settings',
  'default'         => '0',
  'choices'         => [
    'on'  => esc_html__('Enable', 'solvior'),
    'off' => esc_html__('Disable', 'solvior'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
