<?php

/**
 * Customizer General Settings
 *
 * style for theme general settings
 */

$fields[] = [
    'type'     => 'custom',
    'settings' => 'general_custom_01',
    'label'    => FALSE,
    'section'  => 'general_settings',
    'default'  => '<div class="customizer_label">' . esc_html__('Global Site Settings', 'solvior') . '</div>',
];
// backToTop
$fields[] = [
    'type'     => 'switch',
    'settings' => 'solvior_backtotop',
    'label'    => esc_html__('Show Back to Top', 'solvior'),
    'section'  => 'general_settings',
    'default'  => '0',
    'choices'  => [
        'on'  => esc_html__('Enable', 'solvior'),
        'off' => esc_html__('Disable', 'solvior'),
    ],
];

$fields[] = [
    'type'     => 'text',
    'settings' => 'backtotop_text',
    'label'    => esc_html__('Back to top Text', 'solvior'),
    'section'  => 'general_settings',
    'default'  => esc_html__('Go to top', 'solvior'),
    'active_callback' => [
        [
            'setting'  => 'solvior_backtotop',
            'operator' => '==',
            'value'    => true,
        ],
    ],
];

// preloader
$fields[] = [
    'type'     => 'switch',
    'settings' => 'show_preloader',
    'label'    => esc_html__('Show Preloader', 'solvior'),
    'section'  => 'general_settings',
    'default'  => '0',
    'choices'  => [
        'on'  => esc_html__('Enable', 'solvior'),
        'off' => esc_html__('Disable', 'solvior'),
    ],
];
// Preloader logo
$fields[] = [
    'type'        => 'image',
    'settings'    => 'preloader_logo',
    'label'       => esc_html__('Preloader Logo', 'solvior'),
    'section'     => 'general_settings',
    'default'     => SOLVIOR_ASSETS_IMAGES_URL . '/loader.svg',
    'active_callback' => [
        [
            'setting'  => 'show_preloader',
            'operator' => '==',
            'value'    => true,
        ],
    ],
];
// background color
$fields[] = array(
    'type'            => 'color',
    'settings'        => 'loader_bg_color',
    'label'           => esc_html__('Loader BG Color', 'solvior'),
    'section'         => 'general_settings',
    'choices'         => [
        'alpha' => true,
    ],
    'transport'       => 'auto',
    'output'          => [
        [
            'element'  => '#loading::after',
            'property' => 'background-color',
        ],
    ],
    'active_callback' => [
        [
            'setting'  => 'show_preloader',
            'operator' => '==',
            'value'    => true,
        ],
    ],
);
// loader color
$fields[] = array(
    'type'            => 'color',
    'settings'        => 'loader_anim_color',
    'label'           => esc_html__('Loader Animation Color', 'solvior'),
    'section'         => 'general_settings',
    'choices'         => [
        'alpha' => true,
    ],
    'transport'       => 'auto',
    'output'          => [
        [
            'element'  => '#loading #loading-center #loading-center-absolute .object',
            'property' => 'border-left-color',
        ],
        [
            'element'  => '#loading #loading-center #loading-center-absolute .object',
            'property' => 'border-top-color',
        ],
    ],
    'active_callback' => [
        [
            'setting'  => 'show_preloader',
            'operator' => '==',
            'value'    => true,
        ],
    ],
);

$fields[] = [
    'type'     => 'switch',
    'settings' => 'solvior_mouse_cursor',
    'label'    => esc_html__('Show Mouse Cursor', 'solvior'),
    'section'  => 'general_settings',
    'default'  => '0',
    'choices'  => [
        'on'  => esc_html__('Enable', 'solvior'),
        'off' => esc_html__('Disable', 'solvior'),
    ],
];
