<?php

/**
 * Customizer Header Settings
 *
 * style for theme headers
 */

$headers = Kirki_Helper::get_posts([
  'post_type'      => 'tj-header-builder',
  'post_status'    => 'publish',
  'posts_per_page' => -1,
  'orderby'        => 'title',
  'order'          => 'ASC',
]);

// select headers
$fields[] = [
  'type'     => 'custom',
  'settings' => 'header_setting_custom_01',
  'label'    => FALSE,
  'section'  => 'header_settings',
  'default'  => '<div class="customizer_label">' . esc_html__('Select Headers', 'solvior') . '</div>',
];
$fields[] = [
  'type'     => 'select',
  'settings' => 'select_headers',
  'section'  => 'header_settings',
  'default'  => 'default',
  'choices'  => [
    'default' => esc_html__('Default Headers', 'solvior'),
    'elementor'  => esc_html__('Elementor Headers', 'solvior'),
  ],
];

// elementor headers
if (!empty($headers)) :
  $fields[] = [
    'type'            => 'custom',
    'settings'        => 'header_setting_custom_02',
    'label'           => FALSE,
    'section'         => 'header_settings',
    'default'         => '<div class="customizer_label mt-25">' . esc_html__('Choose Elementor Style', 'solvior') . '</div>',
    'active_callback' => [
      [
        'setting'  => 'select_headers',
        'operator' => '==',
        'value'    => 'elementor',
      ],
    ],
  ];
  $fields[] = [
    'type'            => 'select',
    'settings'        => 'elementor_header_style',
    'label'           => esc_html__('Elementor Header (LTR)', 'solvior'),
    'section'         => 'header_settings',
    'choices'         => $headers,
    'default'         => 'header-1',
    'active_callback' => [
      [
        'setting'  => 'select_headers',
        'operator' => '==',
        'value'    => 'elementor',
      ],
    ],
  ];

  // Elementor header (RTL)
  $fields[] = [
    'type'            => 'select',
    'settings'        => 'elementor_header_style_rtl',
    'label'           => esc_html__('Elementor Header (RTL)', 'solvior'),
    'section'         => 'header_settings',
    'default'         => '',
    'choices'         => $headers,
    'active_callback' => [
      [
        'setting'  => 'select_headers',
        'operator' => '==',
        'value'    => 'elementor',
      ],
    ],
  ];

else :
  $fields[] = [
    'type'            => 'custom',
    'settings'        => 'header_custom_02',
    'label'           => FALSE,
    'section'         => 'header_settings',
    'default'         => '<div class="alert alert-warning" role="alert">' . esc_html__('No Headers Found! — set elementor header {Appearance -> TJ Header Builder}', 'solvior') . '</div>',
    'active_callback' => [
      [
        'setting'  => 'select_headers',
        'operator' => '==',
        'value'    => 'elementor',
      ],
    ],
  ];
endif;

// header settings
$fields[] = [
  'type'     => 'custom',
  'settings' => 'header_setting_custom_04',
  'label'    => FALSE,
  'section'  => 'header_settings',
  'default'  => '<div class="customizer_label mt-25">' . esc_html__('Header Settings', 'solvior') . '</div>',
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
// header sticky
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'header_sticky',
  'label'           => esc_html__('Is header sticky?', 'solvior'),
  'section'         => 'header_settings',
  'default'         => '0',
  'choices'         => [
    'on'  => esc_html__('Enable', 'solvior'),
    'off' => esc_html__('Disable', 'solvior'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
// header absolute
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'header_absolute',
  'label'           => esc_html__('Is header transparent?', 'solvior'),
  'section'         => 'header_settings',
  'default'         => '0',
  'choices'         => [
    'on'  => esc_html__('Enable', 'solvior'),
    'off' => esc_html__('Disable', 'solvior'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];

// header search
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'show_header_search',
  'label'           => esc_html__('Show header search?', 'solvior'),
  'section'         => 'header_settings',
  'default'         => '0',
  'choices'         => [
    'on'  => esc_html__('Enable', 'solvior'),
    'off' => esc_html__('Disable', 'solvior'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];

$fields[] = [
  'type'     => 'textarea',
  'settings' => 'header_search_text',
  'label'    => esc_html__('Search Text', 'solvior'),
  'section'  => 'header_settings',
  'default'  => esc_html__('', 'solvior'),
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'show_header_search',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];

// header Sidebar
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'show_header_button',
  'label'           => esc_html__('Show header Button?', 'solvior'),
  'section'         => 'header_settings',
  'default'         => '0',
  'choices'         => [
    'on'  => esc_html__('Enable', 'solvior'),
    'off' => esc_html__('Disable', 'solvior'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];

// Button Text
$fields[] = [
  'type'     => 'text',
  'settings' => 'header_btn_text',
  'label'    => esc_html__('Button Text', 'solvior'),
  'section'  => 'header_settings',
  'default'  => esc_html__('Get a quote', 'solvior'),
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'show_header_button',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
// Button URL
$fields[] = [
  'type'     => 'text',
  'settings' => 'header_btn_url',
  'label'    => esc_html__('Button Link', 'solvior'),
  'section'  => 'header_settings',
  'default'  => esc_html__('#', 'solvior'),
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'show_header_button',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
