<?php

/**
 * Customizer Mobile Menu
 *
 * style for theme Mobile Menu
 */

$fields[] = array(
  'type'     => 'custom',
  'settings' => 'general_custom_01',
  'label'    => FALSE,
  'section'  => 'solvior_mobile_menu',
  'default'  => '<div class="customizer_label">' . esc_html__('Mobile Menu', 'solvior') . '</div>',
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ]
  ],
);

// search switch
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'solvior_mobile_search',
  'label'           => esc_html__('Show search bar?', 'solvior'),
  'section'         => 'solvior_mobile_menu',
  'default'         => '1',
  'choices'         => [
    'on'  => esc_html__('Enable', 'solvior'),
    'off' => esc_html__('Disable', 'solvior'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ]
  ],
];
// description
$fields[] = [
  'type'     => 'textarea',
  'settings' => 'solvior_mobile_desc',
  'label'    => esc_html__('Description', 'solvior'),
  'section'  => 'solvior_mobile_menu',
  'default'  => esc_html__('We take a bottom-line approach to each project. Our clients consistently, enhanced brand loyalty
      and new leads thanks to our work.', 'solvior'),

  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
// show contact info
$fields[] = [
  'type'     => 'switch',
  'settings' => 'show_mobile_contact',
  'label'    => esc_html__('Show contact info?', 'solvior'),
  'section'  => 'solvior_mobile_menu',
  'default'  => '1',
  'choices'  => [
    'on'  => esc_html__('Enable', 'solvior'),
    'off' => esc_html__('Disable', 'solvior'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
// info title
$fields[] = [
  'type'     => 'text',
  'settings' => 'contact_info_title',
  'label'    => esc_html__('Info title', 'solvior'),
  'section'  => 'solvior_mobile_menu',
  'default'  => esc_html__('Contact Info', 'solvior'),
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'show_mobile_contact',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];

// show contact socials
$fields[] = [
  'type'     => 'switch',
  'settings' => 'show_mobile_socials',
  'label'    => esc_html__('Show socials info?', 'solvior'),
  'section'  => 'solvior_mobile_menu',
  'default'  => '1',
  'choices'  => [
    'on'  => esc_html__('Enable', 'solvior'),
    'off' => esc_html__('Disable', 'solvior'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
// socials title
$fields[] = [
  'type'     => 'text',
  'settings' => 'social_info_title',
  'label'    => esc_html__('Socials title', 'solvior'),
  'section'  => 'solvior_mobile_menu',
  'default'  => esc_html__('Socials Info', 'solvior'),
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'show_mobile_socials',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
