<?php

/**
 * Customizer Logos & Favicon
 *
 * style for theme logos & favicon
 */
$fields[] = [
  'type'     => 'custom',
  'settings' => 'logos_custom_01',
  'label'    => FALSE,
  'section'  => 'solvior_theme_logos',
  'default'  => '<div class="customizer_label">' . esc_html__('Site Logos', 'solvior') . '</div>',
];

// primary logo
$fields[] = [
  'type'     => 'image',
  'settings' => 'primary_logo',
  'label'    => esc_html__('Primary Logo', 'solvior'),
  'section'  => 'solvior_theme_logos',
  'default'     => SOLVIOR_ASSETS_IMAGES_URL . '/logos/primary-logo.png',
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ]
  ],
];
$fields[] = [
  'type'     => 'dimensions',
  'settings' => 'primary_logo_dimension',
  'section'  => 'solvior_theme_logos',
  'transport'   => 'auto',
  'responsive' => true,
  'default'     => [
    'desktop' => [
      'max-width'  => '140px',
      'height' => 'auto',
    ],
    'tablet'  => [
      'max-width'  => '140px',
      'height' => 'auto',
    ],
    'mobile'  => [
      'max-width'  => '110px',
      'height' => 'auto',
    ],
  ],
  'choices'     => [
    'labels' => [
      'max-width'  => esc_html__('Max Width', 'solvior'),
      'height' => esc_html__('Height', 'solvior'),
    ],
  ],
  'output'      => [
    [
      'choice'   => 'max-width',
      'element'  => '.site-logo .primary_logo',
      'property' => 'max-width',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
    [
      'choice'   => 'height',
      'element'  => '.site-logo .primary_logo img',
      'property' => 'height',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ]
  ],
];

// Mobile logo
$fields[] = [
  'type'     => 'image',
  'settings' => 'mobile_logo',
  'label'    => esc_html__('Mobile Logo', 'solvior'),
  'section'  => 'solvior_theme_logos',
  'default'     => SOLVIOR_ASSETS_IMAGES_URL . '/logos/primary-logo.png',
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ]
  ],
];
$fields[] = [
  'type'     => 'dimensions',
  'settings' => 'mobile_logo_dimension',
  'section'  => 'solvior_theme_logos',
  'transport'   => 'auto',
  'responsive' => true,
  'default'     => [
    'desktop' => [
      'max-width'  => '140px',
      'height' => 'auto',
    ],
    'tablet'  => [
      'max-width'  => '140px',
      'height' => 'auto',
    ],
    'mobile'  => [
      'max-width'  => '140px',
      'height' => 'auto',
    ],
  ],
  'choices'     => [
    'labels' => [
      'max-width'  => esc_html__('Max Width', 'solvior'),
      'height' => esc_html__('Height', 'solvior'),
    ],
  ],
  'output'      => [
    [
      'choice'   => 'max-width',
      'element'  => '.logo-area .mobile_logo',
      'property' => 'max-width',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
    [
      'choice'   => 'height',
      'element'  => '.logo-area .mobile_logo img',
      'property' => 'height',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ]
  ],
];
