<?php

/**
 * Customizer Typography Settings
 *
 * style for theme typography
 */

$fields[] = array(
  'type'     => 'custom',
  'settings' => 'font_custom_01',
  'label'    => FALSE,
  'section'  => 'typo_settings',
  'default'  => '<div class="customizer_label">' . esc_html__('Body Font', 'solvior') . '</div>',
);

// Body font
$fields[] = array(
  'type'        => 'typography',
  'settings'    => 'body_fonts',
  'section'     => 'typo_settings',
  'description' => esc_html__('Body Font by default effect on each element under body excepts some special elements those are under Heading Font.', 'solvior'),
  'default'     => [
    'font-family' => 'Lato',
    'variant'     => 'regular',
    'font-size'   => '16px',
    'line-height' => '1.6',
  ],
  'transport'   => 'auto',
  'output'      => [
    [
      'choice'   => 'font-family',
      'element'  => ':root',
      'property' => '--tj-ff-body',
    ],
    [
      'choice'   => 'font-weight',
      'element'  => 'body',
      'property' => 'font-weight',
    ],
    [
      'choice'   => 'font-size',
      'element'  => ':root',
      'property' => '--tj-fs-body',
    ],
    [
      'choice'   => 'line-height',
      'element'  => 'body',
      'property' => 'line-height',
    ],
  ],
);


$fields[] = array(
  'type'     => 'custom',
  'settings' => 'font_custom_02',
  'label'    => FALSE,
  'section'  => 'typo_settings',
  'default'  => '<div class="customizer_label mt-25">' . esc_html__('Heading Font', 'solvior') . '</div>',
);
// Heading font
$fields[] = array(
  'type'        => 'typography',
  'settings'    => 'secondary_fonts',
  'section'     => 'typo_settings',
  'default'     => [
    'font-family' => 'Libre Franklin',
    'variant'     => '600',
  ],
  'description' => esc_html__('This typography settings only for heading, buttons and some special elements.', 'solvior'),
  'transport'   => 'auto',
  'output'      => [
    [
      'choice'   => 'font-family',
      'element'  => ':root',
      'property' => '--tj-ff-heading',
    ],
    [
      'choice'   => 'font-weight',
      'element'  => 'h1,h2,h3,h4,h5,h6',
      'property' => 'font-weight',
    ],
  ],
);
