<?php

/**
 * Solvior TGM_Config
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

class TGM_Config
{

  public function __construct()
  {
    add_action('tgmpa_register', array($this, 'register_required_plugins'));
  }
  public function register_required_plugins()
  {
    $plugins = [
      // Bundled
      [
        'name'               => esc_html__('TJ Solvior Core', 'solvior'),
        'slug'               => 'tj-solvior-core',
        'required'           => true,
        'source'             => esc_url('https://themejunction.net/plugins/tj-solvior-core.zip'),
        'external_url'       =>  esc_url('https://themejunction.net/plugins/tj-solvior-core.zip'),
      ],
      [
        'name'               => esc_html__('Advanced Custom Fields Pro', 'solvior'),
        'slug'               => 'advanced-custom-fields-pro',
        'required'           => true,
        'source'             => esc_url('https://themejunction.net/plugins/advanced-custom-fields-pro.zip'),
        'external_url' => esc_url('https://themejunction.net/plugins/advanced-custom-fields-pro.zip'),
      ],

      // Repository
      [
        'name'     => esc_html__('Kirki', 'solvior'),
        'slug'     => 'kirki',
        'required' => true,
      ],
      [
        'name'     => esc_html__('Elementor', 'solvior'),
        'slug'     => 'elementor',
        'required' => true,
      ],
      [
        'name'     => esc_html__('Breadcrumb NavXT', 'solvior'),
        'slug'     => 'breadcrumb-navxt',
        'required' => true,
      ],
      [
        'name'     => esc_html__('Contact Form 7', 'solvior'),
        'slug'     => 'contact-form-7',
        'required' => true,
      ],
      [
        'name'     => esc_html__('Advanced Custom Fields: Font Awesome Field', 'solvior'),
        'slug'     => 'advanced-custom-fields-font-awesome',
        'required' => false,
      ],
      [
        'name'     => esc_html__('One Click Demo Import', 'solvior'),
        'slug'     => 'one-click-demo-import',
        'required' => false,
      ],
      [
        'name'     => esc_html__('Classic Editor', 'solvior'),
        'slug'     => 'classic-editor',
        'required' => false,
      ],
      [
        'name'     => esc_html__('Classic Widgets', 'solvior'),
        'slug'     => 'classic-widgets',
        'required' => false,
      ],
      [
        'name'         => esc_html__('WooCommerce', 'solvior'),
        'slug'         => 'woocommerce',
        'required'     => false,
      ],
      [
        'name'         => esc_html__('WPC Smart Wishlist', 'solvior'),
        'slug'         => 'woo-smart-wishlist',
        'required'     => false,
      ],
      [
        'name'         => esc_html__('WPC Smart Quick View', 'solvior'),
        'slug'         => 'woo-smart-quick-view',
        'required'     => false,
      ],
      [
        'name'         => esc_html__('Polylang', 'solvior'),
        'slug'         => 'polylang',
        'required'     => false,
      ],
    ];

    $config = [
      'id'           => 'solvior',            // Unique ID for hashing notices for multiple instances of TGMPA.
      'default_path' => '',              // Default absolute path to bundled plugins.
      'menu'         => 'install-required-plugins', // Menu slug.
      'has_notices'  => true,                    // Show admin notices or not.
      'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
      'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
      'is_automatic' => false,                    // Automatically activate plugins after installation or not.
      'message'      => '',                      // Message to output right before the plugins table.
    ];

    tgmpa($plugins, $config);
  }
}
new TGM_Config;
