<?php

/**
 * Functions which enhance the theme by Custom Functions
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

/**
 * ---------------------------------------------------------------------------------------
 * Solvior Before Content
 * ---------------------------------------------------------------------------------------
 */
// Preloader
add_action('wp_body_open', 'solvior_preloader');
function solvior_preloader() {
  $solviorPreloader = get_theme_mod('show_preloader', false);
  $prealoderLogo   = SOLVIOR_ASSETS_IMAGES_URL . '/loader.svg';
  $loaderImage = get_theme_mod('preloader_logo', $prealoderLogo);

  if (!empty($solviorPreloader)) :
?>
    <!-- preloader -->
    <div class="preloader">
      <div class="loading-container">
        <div class="loading"></div>
        <div id="loading-icon">
          <img src="<?php echo esc_url($loaderImage); ?>" alt="<?php echo esc_attr(get_post_meta(attachment_url_to_postid($loaderImage), '_wp_attachment_image_alt', true)); ?>">
        </div>
      </div>
    </div>
    <!-- end: Preloader -->
  <?php
  endif;
}

// Back to Top
add_action('solvior_before_main_content', 'solvior_back_to_top');
function solvior_back_to_top() {

  $solviorBackToTop = get_theme_mod('solvior_backtotop', false);
  $backtotop_text = get_theme_mod('backtotop_text', __('Go to top', 'solvior'));

  if (!empty($solviorBackToTop)) :
  ?>
    <div class="back-to-top-wrapper">
      <button id="back_to_top" type="button" class="back-to-top-btn">
        <i class="tji-arrow-up"></i>
        <?php if (!empty($backtotop_text)) : ?>
          <span><?php echo esc_html($backtotop_text); ?></span>
        <?php endif; ?>
      </button>
    </div>
  <?php endif;
}

// Mouse cursor
add_action('solvior_before_main_content', 'solvior_mouse_cursor');
function solvior_mouse_cursor() {

  $mouse_cursor = get_theme_mod('solvior_mouse_cursor', false);

  if (!empty($mouse_cursor)) :
  ?>
    <!-- Start: Mouse cursor -->
    <div class="mouseCursor cursor-outer"></div>
    <div class="mouseCursor cursor-inner">
      <span><i class="tji-angle-left"></i><?php echo esc_html__('Drag', 'solvior'); ?><i class="tji-angle-right"></i></span>
    </div>
    <!-- End: Mouse cursor -->
    <?php
  endif;
}

/**
 * ---------------------------------------------------------------------------------------
 * Solvior Search Filter
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('solvior_search_filter_form')) {
  function solvior_search_filter_form($form) {
    $form = sprintf(
      '<div class="tj-widget__search sidebar-search"><form action="%s" method="get">
       <input type="search" value="%s" required name="s" placeholder="%s">
       <button type="submit"> <i class="fa-regular fa-magnifying-glass"></i> </button>
    </form></div>',
      esc_url(home_url('/')),
      esc_attr(get_search_query()),
      esc_html__('Search...', 'solvior')
    );

    return $form;
  }
  add_filter('get_search_form', 'solvior_search_filter_form');
}

/**
 * ---------------------------------------------------------------------------------------
 * Solvior Breadcrumb
 * ---------------------------------------------------------------------------------------
 */
add_action('solvior_breadcrumb', 'solvior_breadcrumb_func');
function solvior_breadcrumb_func() {
  global $post;

  // id
  $_id = get_the_ID();

  $breadcrumb_class = '';
  $breadcrumb_show = 1;

  $show_breadcrumb = get_theme_mod('show_breadcrumb', true);

  // page breadcrumb title
  $page_breadcrumb_title = function_exists('get_field') ? get_field('page_breadcrumb_title', $_id) : '';

  if (!empty($show_breadcrumb)) :
    // title
    if (is_front_page() && is_home()) {
      $title = get_theme_mod('blog_breadcrumb_title', esc_html__('Blog', 'solvior'));
      $breadcrumb_class = 'home_front_page';
    } elseif (is_front_page()) {
      $title = get_theme_mod('blog_breadcrumb_title', esc_html__('Blog', 'solvior'));
      $breadcrumb_show = 0;
    } elseif (is_home()) {
      $title = get_theme_mod('blog_breadcrumb_title', esc_html__('Blog', 'solvior'));
      $breadcrumb_class = 'home_blog_page';
    } elseif (is_single() && 'post' == get_post_type()) {
      if (!empty(get_theme_mod('blog_details_breadcrumb_title'))) {
        $title = get_theme_mod('blog_details_breadcrumb_title', esc_html__('Blog Details', 'solvior'));
      } else {
        $title =  get_the_title();
      }
    } elseif (is_single() && 'product' == get_post_type()) {
      $title =  get_the_title();
    } elseif (is_search()) {
      $title = esc_html__('Search Results for : ', 'solvior') . get_search_query();
    } elseif (is_404()) {
      $title = get_theme_mod('solvior_error_title',  esc_html__('404', 'solvior'));
      $breadcrumb_show = 1;
    } elseif (function_exists('is_woocommerce') && is_woocommerce()) {
      $title = get_theme_mod('breadcrumb_shop', esc_html__('Shop', 'solvior'));
    } elseif (is_archive() && 'services' == get_post_type()) {
      $breadcrumb_class = 'solvior_services_archive';
      if (!empty(get_theme_mod('breadcrumb_services_title'))) {
        $title = get_theme_mod('breadcrumb_services_title', esc_html__('Services', 'solvior'));
      } else {
        $title =  get_the_archive_title();
      }
    } elseif (is_single() && 'services' == get_post_type()) {
      $breadcrumb_class = 'solvior_service_single';
      $title = !empty($page_breadcrumb_title) ? $page_breadcrumb_title : get_the_title();
    } elseif (is_archive() && 'projects' == get_post_type()) {
      $breadcrumb_class = 'solvior_projects_archive';
      if (!empty(get_theme_mod('breadcrumb_projects_title'))) {
        $title = get_theme_mod('breadcrumb_projects_title', esc_html__('Projects', 'solvior'));
      } else {
        $title =  get_the_archive_title();
      }
    } elseif (is_single() && 'projects' == get_post_type()) {
      $breadcrumb_class = 'solvior_project_single';
      $title = !empty($page_breadcrumb_title) ? $page_breadcrumb_title : get_the_title();
    } elseif (is_archive()) {
      $title = get_the_archive_title();
    } else {
      $title = !empty($page_breadcrumb_title) ? $page_breadcrumb_title : get_the_title();
    }


    if (is_single() && 'product' == get_post_type()) {
      $_id = $post->ID;
    } elseif (function_exists("is_shop") and is_shop()) {
      $_id = wc_get_page_id('shop');
    } elseif (is_home() && get_option('page_for_posts')) {
      $_id = get_option('page_for_posts');
    }

    // hide page breadcrumb
    if (is_singular() || is_page()) {
      $is_breadcrumb = function_exists('get_field') ? get_field('hide_page_breadcrumb', $_id) : false;
    } else {
      $is_breadcrumb = false;
    }

    if ((false == $is_breadcrumb) && $breadcrumb_show == 1) {
      // IMAGES
      $breadcrumb_page_bg_image = function_exists('get_field') ? get_field('breadcrumb_page_bg_image', $_id) : '';

      // customizer
      $customizer_bg_img = get_theme_mod('breadcrumb_bg_img');
      $bg_color = get_theme_mod('breadcrumb_bg_color');

      $blog_breadcrumb_img = get_theme_mod('blog_breadcrumb_img');
      $blog_details_breadcrumb_img = get_theme_mod('blog_details_breadcrumb_img');
      $breadcrumb_service_img = get_theme_mod('breadcrumb_services_img');
      $breadcrumb_projects_img = get_theme_mod('breadcrumb_projects_img');
      $error_breadcrumb_img = get_theme_mod('solvior_error_breadcrumb_img');
      $breadcrumb_shop_img = get_theme_mod('breadcrumb_shop_img');

      // image
      if (is_front_page() && is_home()) {
        $bg_img = $blog_breadcrumb_img ? $blog_breadcrumb_img : $customizer_bg_img;
      } elseif (is_front_page()) {
        $bg_img = $blog_breadcrumb_img ? $blog_breadcrumb_img : $customizer_bg_img;
      } elseif (is_home()) {
        $bg_img = $blog_breadcrumb_img ? $blog_breadcrumb_img : $customizer_bg_img;
      } elseif (is_single() && 'post' == get_post_type()) {
        $bg_img = $blog_details_breadcrumb_img ? $blog_details_breadcrumb_img : (has_post_thumbnail() ? get_the_post_thumbnail_url() : $customizer_bg_img);
      } elseif (is_404()) {
        $bg_img = $error_breadcrumb_img ? $error_breadcrumb_img : $customizer_bg_img;
      } elseif (is_archive() && 'services' == get_post_type()) {
        $bg_img = $breadcrumb_service_img ? $breadcrumb_service_img : $customizer_bg_img;
      } elseif (is_single() && 'services' == get_post_type()) {
        $bg_img = !empty($breadcrumb_page_bg_image['url']) ? $breadcrumb_page_bg_image['url'] : ($breadcrumb_service_img ? $breadcrumb_service_img : $customizer_bg_img);
      } elseif (is_archive() && 'projects' == get_post_type()) {
        $bg_img = $breadcrumb_projects_img ? $breadcrumb_projects_img : $customizer_bg_img;
      } elseif (is_single() && 'projects' == get_post_type()) {
        $bg_img = !empty($breadcrumb_page_bg_image['url']) ? $breadcrumb_page_bg_image['url'] : ($breadcrumb_projects_img ? $breadcrumb_projects_img : $customizer_bg_img);
      } elseif (is_archive() && 'product' == get_post_type()) {
        $bg_img = $breadcrumb_shop_img ? $breadcrumb_shop_img : $customizer_bg_img;
      } elseif (is_single()) {
        $bg_img = has_post_thumbnail() ? get_the_post_thumbnail_url() : $customizer_bg_img;
      } else {
        $bg_img = !empty($breadcrumb_page_bg_image['url']) ? $breadcrumb_page_bg_image['url'] : $customizer_bg_img;
      }

      // NAVIGATION
      $breadcrumb_navigation_switch = get_theme_mod('breadcrumb_navigation_switch', false);
      $is_navigation = $breadcrumb_navigation_switch;
      $breadcrumb_space = get_theme_mod('breadcrumb_space', false);
      $title_animation = get_theme_mod('breadcrumb_title_animation', true);
      $pheaderSpace = !empty($breadcrumb_space) ? "pheader-space" : "pheader-space-2";
      $active_animation = !empty($title_animation) ? "text-anim" : "";

      // breadcrumb bg color
      if (!empty($bg_color)) {
        $bgColor = 'data-bg-color=' . $bg_color . '';
      } else {
        $bgColor = "";
      }

      // breadcrumb bg image
      if (!empty($bg_img)) {
        $bgImage = 'data-bg-image=' . $bg_img . '';
      } else {
        $bgImage = "";
      }
    ?>
      <section class="tj-page-header <?php echo esc_attr($breadcrumb_class); ?> <?php echo esc_attr($pheaderSpace); ?>" <?php echo esc_attr($bgColor); ?> <?php echo esc_attr($bgImage);  ?>>
        <div class="container">
          <div class="row">
            <div class="col-lg-12">
              <div class="tj-page-header-content text-center">
                <h1 class="tj-page-title <?php echo esc_attr($active_animation); ?>">
                  <?php echo solvior_kses($title); ?>
                </h1>
                <?php if (!empty($is_navigation)) : ?>
                  <?php if (function_exists('bcn_display')) : ?>
                    <div class="tj-page-link wow fadeInUp" data-wow-delay="0.1s">
                      <?php bcn_display(); ?>
                    </div>
                  <?php endif; ?>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      </section>
    <?php
    }
  endif;
}
add_filter('bcn_breadcrumb_title', 'solvior_breadcrumb_current_title_trim', 3, 10);
function solvior_breadcrumb_current_title_trim($title, $type, $id) {
  $parentTitle = get_theme_mod('breadcrumb_parent_title', esc_html__("Home", 'solvior'));
  $word_count = get_theme_mod('breadcrumb_word_count', esc_html__("4", 'solvior'));
  if (in_array('home', $type)) {
    $title = esc_html($parentTitle);
  }
  if (in_array('post', $type)) {
    $title = wp_trim_words($title, $word_count, '...');
  }
  return $title;
}
add_filter('get_the_archive_title_prefix', '__return_false');

/**
 * ---------------------------------------------------------------------------------------
 * Solvior Header Style
 * ---------------------------------------------------------------------------------------
 */
add_action('solvior_header_style', 'solvior_check_header', 10);
function solvior_check_header() {

  $solvior_select_headers = get_theme_mod('select_headers', 'default');
  $elementor_header_style = is_rtl() ? get_theme_mod('elementor_header_style_rtl', 0) : get_theme_mod('elementor_header_style', 0);

  $default_header_style   = get_theme_mod('default_header_style', 'header-style-1');

  // header style from page settings
  $enable_header_settings = function_exists('get_field') ? get_field('enable_header_settings') : false;
  $select_page_headers = function_exists('get_field') ? get_field('select_page_headers') : 'default-headers';

  $page_default_header_style = function_exists('get_field') ? get_field('page_default_header_style') : "";
  $page_elementor_header_style = function_exists('get_field') ? get_field('page_elementor_header_style') : "";


  // from page headers
  if (!empty($enable_header_settings) && is_page()) {
    if ('default-headers' == $select_page_headers) {
      // page header style
      if ($page_default_header_style == 'header-style-3') {
        get_template_part('template-parts/header/header-3');
      } elseif ($page_default_header_style == 'header-style-2') {
        get_template_part('template-parts/header/header-2');
      } else {
        get_template_part('template-parts/header/header-1');
      }
    } else {
      if (class_exists('\\Elementor\\Plugin')) {
        if ($page_elementor_header_style) {
          TJ_HF_Builder::render_template($page_elementor_header_style->ID);
        } else {
          printf('<div class="alert alert-warning" role="alert">%s</div>', esc_html__('No Headers Found! — set custom header {Appearance -> TJ Header Builder}', 'solvior'));
        }
      } else {
        printf('<div class="alert alert-warning" role="alert">%s</div>', esc_html__('Solvior requires Elementor to be installed and activated.', 'solvior'));
      }
    }
  } else {
    // from cutomizer headers
    if ('default' == $solvior_select_headers) {
      /** default header style **/
      if ($default_header_style == 'header-style-3') {
        get_template_part('template-parts/header/header-3');
      } elseif ($default_header_style == 'header-style-2') {
        get_template_part('template-parts/header/header-2');
      } else {
        get_template_part('template-parts/header/header-1');
      }
    } else {
      if (class_exists('\\Elementor\\Plugin')) {
        if ($elementor_header_style > 0) {
          TJ_HF_Builder::render_template($elementor_header_style);
        } else {
          printf('<div class="alert alert-warning" role="alert">%s</div>', esc_html__('No Headers Found! — set custom header {Appearance -> TJ Header Builder}', 'solvior'));
        }
      } else {
        printf('<div class="alert alert-warning" role="alert">%s</div>', esc_html__('Solvior requires Elementor to be installed and activated.', 'solvior'));
      }
    }
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Solvior Footer Style
 * ---------------------------------------------------------------------------------------
 */
add_action('solvior_footer_style', 'solvior_check_footer', 10);
function solvior_check_footer() {

  $solvior_select_footers = get_theme_mod('select_footers', 'default');
  $elementor_footer_style = is_rtl() ? get_theme_mod('elementor_footer_style_rtl', 0) : get_theme_mod('elementor_footer_style', 0);
  $default_footer_style   = get_theme_mod('default_footer_style', 'footer-style-1');

  // footer style from page settings
  $enable_footer_settings = function_exists('get_field') ? get_field('enable_footer_settings') : false;
  $select_page_footers = function_exists('get_field') ? get_field('select_page_footers') : 'default-footers';

  $page_default_footer_style = function_exists('get_field') ? get_field('page_default_footer_style') : "";
  $page_elementor_footer_style = function_exists('get_field') ? get_field('page_elementor_footer_style') : "";


  // from Page Footers
  if (!empty($enable_footer_settings) && is_page()) {
    if ('default-footers' == $select_page_footers) {
      // page footer style
      if ($page_default_footer_style == 'footer-style-3') {
        get_template_part('template-parts/footer/footer-3');
      } elseif ($page_default_footer_style == 'footer-style-2') {
        get_template_part('template-parts/footer/footer-2');
      } else {
        get_template_part('template-parts/footer/footer-1');
      }
    } else {

      if (class_exists('\\Elementor\\Plugin')) {
        if ($page_elementor_footer_style) {
          TJ_HF_Builder::render_template($page_elementor_footer_style->ID);
        } else {
          printf('<div class="alert alert-warning" role="alert">%s</div>', esc_html__('No Footers Found! — set custom header {Appearance -> TJ Footer Builder}', 'solvior'));
        }
      } else {
        printf('<div class="alert alert-warning" role="alert">%s</div>', esc_html__('Solvior requires Elementor to be installed and activated.', 'solvior'));
      }
    }
  } else {
    // from cutomizer Footers
    if ('default' == $solvior_select_footers) {
      /** default footer style **/
      if ($default_footer_style == 'footer-style-3') {
        get_template_part('template-parts/footer/footer-3');
      } elseif ($default_footer_style == 'footer-style-2') {
        get_template_part('template-parts/footer/footer-2');
      } else {
        get_template_part('template-parts/footer/footer-1');
      }
    } else {

      if (class_exists('\\Elementor\\Plugin')) {
        if ($elementor_footer_style > 0) {
          TJ_HF_Builder::render_template($elementor_footer_style);
        } else {
          printf('<div class="alert alert-warning" role="alert">%s</div>', esc_html__('No Footers Found! — set custom header {Appearance -> TJ Footer Builder}', 'solvior'));
        }
      } else {
        printf('<div class="alert alert-warning" role="alert">%s</div>', esc_html__('Solvior requires Elementor to be installed and activated.', 'solvior'));
      }
    }
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Solvior Header Logo
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('solvior_header_logo')) {
  function solvior_header_logo() {
    $primaryLogo       = SOLVIOR_ASSETS_IMAGES_URL . '/logos/primary-logo.png';

    $solviorPrimaryLogo      = get_theme_mod('primary_logo', $primaryLogo);
    ?>
    <?php if (!empty($solviorPrimaryLogo)) : ?>
      <a class="primary_logo logo" href="<?php echo esc_url(home_url('/')); ?>">
        <img src="<?php echo esc_url($solviorPrimaryLogo); ?>" alt="<?php echo esc_attr(get_post_meta(attachment_url_to_postid($solviorPrimaryLogo), '_wp_attachment_image_alt', true)); ?>">
      </a>
    <?php endif; ?>
  <?php
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Solvior Header Mobile Logo
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('solvior_mobile_logo')) {
  function solvior_mobile_logo() {
    $solviorMobileLogo = get_theme_mod('mobile_logo', SOLVIOR_ASSETS_IMAGES_URL . '/logos/primary-logo.png');
  ?>
    <a href="<?php echo esc_url(home_url('/')); ?>" class="mobile_logo">
      <img src="<?php echo esc_url($solviorMobileLogo); ?>" alt="<?php echo esc_attr(get_post_meta(attachment_url_to_postid($solviorMobileLogo), '_wp_attachment_image_alt', true)); ?>">
    </a>
  <?php   }
}

/**
 * ---------------------------------------------------------------------------------------
 * Solvior Header Menu
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('solvior_header_menu')) {
  function solvior_header_menu() {

    if (has_nav_menu('main-menu')) {
      wp_nav_menu([
        'theme_location' => 'main-menu',
        'menu_class'     => '',
        'menu_id'        => '',
        'container'      => '',
        'fallback_cb'    => 'Solvior_Navwalker_Class::fallback',
        'walker'         => new \TJCore\Solvior_Navwalker_Class,
      ]);
    } else {
      wp_nav_menu([
        'menu_class'     => '',
        'container'      => '',
      ]);
    }
  }
}


/**
 * ---------------------------------------------------------------------------------------
 * Header Footer Menu
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('solvior_footer_menu')) {
  function solvior_footer_menu() {
    if (has_nav_menu('footer-menu')) {
      wp_nav_menu([
        'theme_location' => 'footer-menu',
        'menu_class'     => '',
        'container'      => '',
        'fallback_cb'    => 'Solvior_Navwalker_Class::fallback',
        'walker'         => new \TJCore\Solvior_Navwalker_Class,
      ]);
    } else {
      wp_nav_menu([
        'menu_class'     => '',
        'container'      => '',
      ]);
    }
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Solvior Copyright Text
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('solvior_copyright_text')) {
  function solvior_copyright_text() {
    $solvior_copyright = get_theme_mod('solvior_copyright', solvior_kses('© 2025 Solvior, All Rights Reserved. Design By <a href="#">Theme Junction</a>'));
    echo solvior_kses($solvior_copyright);
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Solvior Socials
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('solvior_socials')) {
  function solvior_socials() {
    $solviorFacebookLink  = get_theme_mod('solvior_fb_link', __('https://facebook.com/', 'solvior'));
    $solviorTwitterLink   = get_theme_mod('solvior_twitter_link', __('https://twitter.com/', 'solvior'));
    $solviorInstagramLink = get_theme_mod('solvior_instagram_link', __('https://instagram.com/', 'solvior'));
    $solviorLinkedinLink  = get_theme_mod('solvior_linkedin_link', __('https://linkedin.com/', 'solvior'));
    $solviorPinterestLink = get_theme_mod('solvior_pinterest_link', '');
    $solviorYoutubeLink   = get_theme_mod('solvior_youtube_link', '');
    $solviorVimeoLink   = get_theme_mod('solvior_vimeo_link', '');
    $solviorGithubLink  = get_theme_mod('solvior_github_link', '');
    $solviorFlickrLink  = get_theme_mod('solvior_flickr_link', '');
    $solviorBehanceLink  = get_theme_mod('solvior_behance_link', '');
    $solviorDribbbleLink = get_theme_mod('solvior_dribbble_link', '');
  ?>
    <ul>
      <?php if (!empty($solviorFacebookLink)) : ?>
        <li>
          <a target="_blank" href="<?php echo esc_url($solviorFacebookLink); ?>">
            <i class="fa-brands fa-facebook-f"></i>
          </a>
        </li>
      <?php endif;

      if (!empty($solviorTwitterLink)) : ?>
        <li>
          <a target="_blank" href="<?php echo esc_url($solviorTwitterLink); ?>">
            <i class="fa-brands fa-twitter"></i>
          </a>
        </li>
      <?php endif;

      if (!empty($solviorInstagramLink)) : ?>
        <li>
          <a target="_blank" href="<?php echo esc_url($solviorInstagramLink); ?>">
            <i class="fa-brands fa-instagram"></i>
          </a>
        </li>
      <?php endif;

      if (!empty($solviorLinkedinLink)) : ?>
        <li>
          <a target="_blank" href="<?php echo esc_url($solviorLinkedinLink); ?>">
            <i class="fa-brands fa-linkedin-in"></i>
          </a>
        </li>
      <?php endif;

      if (!empty($solviorPinterestLink)) : ?>
        <li>
          <a target="_blank" href="<?php echo esc_url($solviorPinterestLink); ?>">
            <i class="fa-brands fa-pinterest-p"></i>
          </a>
        </li>
      <?php endif;

      if (!empty($solviorYoutubeLink)) : ?>
        <li>
          <a target="_blank" href="<?php echo esc_url($solviorYoutubeLink); ?>">
            <i class="fa-brands fa-youtube"></i>
          </a>
        </li>
      <?php endif;

      if (!empty($solviorVimeoLink)) : ?>
        <li>
          <a target="_blank" href="<?php echo esc_url($solviorVimeoLink); ?>">
            <i class="fa-brands fa-vimeo"></i>
          </a>
        </li>
      <?php endif;

      if (!empty($solviorGithubLink)) : ?>
        <li>
          <a target="_blank" href="<?php echo esc_url($solviorGithubLink); ?>">
            <i class="fa-brands fa-github"></i>
          </a>
        </li>
      <?php endif;

      if (!empty($solviorFlickrLink)) : ?>
        <li>
          <a target="_blank" href="<?php echo esc_url($solviorFlickrLink); ?>">
            <i class="fa-brands fa-flickr"></i>
          </a>
        </li>
      <?php endif;

      if (!empty($solviorBehanceLink)) : ?>
        <li>
          <a target="_blank" href="<?php echo esc_url($solviorBehanceLink); ?>">
            <i class="fa-brands fa-behance"></i>
          </a>
        </li>
      <?php endif;

      if (!empty($solviorDribbbleLink)) : ?>
        <li>
          <a target="_blank" href="<?php echo esc_url($solviorDribbbleLink); ?>">
            <i class="fa-brands fa-dribbble"></i>
          </a>
        </li>
      <?php endif; ?>
    </ul>

  <?php
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Solvior Pagination
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('solvior_pagination')) {

  function _solvior_pagi_callback($pagination) {
    return $pagination;
  }

  //page navigation
  function solvior_pagination($prev, $next, $pages, $args) {
    global $wp_query, $wp_rewrite;
    $menu                                         = '';
    $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;

    if ($pages == '') {
      global $wp_query;
      $pages = $wp_query->max_num_pages;

      if (!$pages) {
        $pages = 1;
      }
    }

    $pagination = [
      'base'      => add_query_arg('paged', '%#%'),
      'format'    => '',
      'total'     => $pages,
      'current'   => $current,
      'prev_text' => $prev,
      'next_text' => $next,
      'type'      => 'array',
    ];

    //rewrite permalinks
    if ($wp_rewrite->using_permalinks()) {
      $pagination['base'] = user_trailingslashit(trailingslashit(remove_query_arg('s', get_pagenum_link(1))) . 'page/%#%/', 'paged');
    }

    if (!empty($wp_query->query_vars['s'])) {
      $pagination['add_args'] = ['s' => get_query_var('s')];
    }

    $pagi = '';
    if (paginate_links($pagination) != '') {
      $paginations = paginate_links($pagination);
      $pagi .= '<ul>';
      foreach ($paginations as $key => $pg) {
        $pagi .= '<li>' . $pg . '</li>';
      }
      $pagi .= '</ul>';
    }

    echo _solvior_pagi_callback($pagi);
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Solvior Comment
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('solvior_comment')) {
  function solvior_comment($comment, $args, $depth) {
    $GLOBAL['comment'] = $comment;
    extract($args, EXTR_SKIP);
    $args['reply_text'] = '<i class="tji-reply"></i>Reply';
    $replayClass        = 'comment-depth-' . esc_attr($depth);
  ?>
    <li class="tj-comment" id="comment-<?php comment_ID(); ?>">
      <div class="comment-content">
        <div class="comments-header">
          <?php if (get_avatar($comment)) : ?>
            <div class="comment-avatar">
              <?php echo get_avatar($comment, 102, null, null, ['class' => []]); ?>
            </div>
          <?php endif; ?>
          <div class="avatar-name">
            <h5 class="title"><?php echo get_comment_author_link(); ?></h5>
            <div class="comment-text">
              <span class="date"><?php comment_time(get_option('date_format')); ?></span>
              <?php comment_reply_link(array_merge($args, ['depth' => $depth, 'max_depth' => $args['max_depth']])); ?>
            </div>
          </div>
        </div>
        <div class="desc">
          <?php comment_text(); ?>
        </div>
      </div>
  <?php
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * WP kses allowed tags
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('solvior_kses')) {
  function solvior_kses($raw) {

    $allowed_tags = array(
      'a'                             => array(
        'class'  => array(),
        'href'   => array(),
        'rel'    => array(),
        'title'  => array(),
        'target' => array(),
      ),
      'abbr'                          => array(
        'title' => array(),
      ),
      'b'                             => array(),
      'blockquote'                    => array(
        'cite' => array(),
      ),
      'cite'                          => array(
        'title' => array(),
      ),
      'code'                          => array(),
      'del'                           => array(
        'datetime' => array(),
        'title'    => array(),
      ),
      'dd'                            => array(),
      'div'                           => array(
        'class' => array(),
        'title' => array(),
        'style' => array(),
      ),
      'dl'                            => array(),
      'dt'                            => array(),
      'em'                            => array(),
      'h1'                            => array(),
      'h2'                            => array(),
      'h3'                            => array(),
      'h4'                            => array(),
      'h5'                            => array(),
      'h6'                            => array(),
      'i'                             => array(
        'class' => array(),
      ),
      'img'                           => array(
        'alt'    => array(),
        'class'  => array(),
        'height' => array(),
        'src'    => array(),
        'width'  => array(),
      ),
      'li'                            => array(
        'class' => array(),
      ),
      'ol'                            => array(
        'class' => array(),
      ),
      'p'                             => array(
        'class' => array(),
      ),
      'q'                             => array(
        'cite'  => array(),
        'title' => array(),
      ),
      'span'                          => array(
        'class' => array(),
        'title' => array(),
        'style' => array(),
      ),
      'iframe'                        => array(
        'width'       => array(),
        'height'      => array(),
        'scrolling'   => array(),
        'frameborder' => array(),
        'allow'       => array(),
        'src'         => array(),
      ),
      'strike'                        => array(),
      'br'                            => array(),
      'strong'                        => array(),
      'data-wow-duration'             => array(),
      'data-wow-delay'                => array(),
      'data-wallpaper-options'        => array(),
      'data-stellar-background-ratio' => array(),
      'ul'                            => array(
        'class' => array(),
      ),
      'svg'                           => array(
        'class'           => true,
        'aria-hidden'     => true,
        'aria-labelledby' => true,
        'role'            => true,
        'xmlns'           => true,
        'width'           => true,
        'height'          => true,
        'viewbox'         => true, // <= Must be lower case!
      ),
      'g'                             => array('fill' => true),
      'title'                         => array('title' => true),
      'path'                          => array('d' => true, 'fill' => true),
    );

    if (function_exists('wp_kses')) { // WP is here
      $allowed = wp_kses($raw, $allowed_tags);
    } else {
      $allowed = $raw;
    }

    return $allowed;
  }
}


/**
 * ---------------------------------------------------------------------------------------
 * Check if Elementor is activated
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('solvior_check_elementor_installed')) {

  function solvior_check_elementor_installed() {
    return did_action('elementor/loaded');
  }
}


/**
 * ---------------------------------------------------------------------------------------
 * Check if page build with elementor 
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('solvior_check_is_elementor')) {
  function solvior_check_is_elementor() {
    global $post;
    if (did_action('elementor/loaded')) {
      return \Elementor\Plugin::$instance->documents->get($post->ID)->is_built_with_elementor();
    }
    return false;
  }
}
