<?php

/**
 * Solvior Theme Hooks Class
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

if (!function_exists('solvior_setup')) :
  function solvior_setup()
  {

    /* load theme languages */
    load_theme_textdomain('solvior', SOLVIOR_THEME_DIR . '/languages');

    /* add title tag support */
    add_theme_support('title-tag');

    /* Add default posts and comments RSS feed links to head */
    add_theme_support('automatic-feed-links');

    /* Add posts thumbnails */
    add_theme_support('post-thumbnails');

    // /* Add Image Size */
    // add_image_size('blog_thumb_1', 832, 590, true);

    /*
    * Switch default core markup for search form, comment form, and comments
    * to output valid HTML5.
    */
    add_theme_support(
      'html5',
      [
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
        'script',
        'style',
        'navigation-widgets'
      ]
    );

    /* Set up the WordPress core custom background feature. */
    add_theme_support(
      'custom-background',
      apply_filters(
        'solvior_custom_background_args',
        [
          'default-color' => 'ffffff',
          'default-image' => '',
        ]
      )
    );

    /* Add theme support for selective refresh for widgets. */
    add_theme_support('customize-selective-refresh-widgets');

    /* Enable support for Post Formats. */
    add_theme_support('post-formats', ['image', 'audio', 'video', 'gallery', 'quote']);

    /* Add support for custom header */
    add_theme_support("custom-header");

    /* Add support for core custom logo. */
    add_theme_support('custom-logo', [
      'height'      => 170,
      'width'       => 60,
      'flex-width'  => true,
      'flex-height' => true,
    ]);

    /* Add support for Block Styles. */
    add_theme_support('wp-block-styles');

    /* Add support for full and wide align images. */
    add_theme_support('align-wide');

    /* Add support for editor styles. */
    add_theme_support('editor-styles');

    // Enqueue editor styles.
    add_editor_style('style.css');

    /* Add support for responsive embedded content. */
    add_theme_support('responsive-embeds');

    /* Support for elementor header and footer */
    if (class_exists('Header_Footer_Elementor')) {
      add_theme_support('header-footer-elementor');
    }

    /* Register nav menus. */
    register_nav_menus(
      [
        'main-menu'   => esc_html__('Main Menu', 'solvior'),
        'footer-menu' => esc_html__('Footer Menu', 'solvior'),
      ]
    );
  }

endif;
add_action('after_setup_theme', 'solvior_setup');


function solvior_register_block_features()
{
  // Register block styles         
  if (function_exists('register_block_style')) {
    register_block_style(
      'core/paragraph',
      [
        'name'  => 'solvior-custom-style',
        'label' => __('Custom Style', 'solvior'),
      ]
    );
  }

  // Register block patterns         
  if (function_exists('register_block_pattern')) {
    register_block_pattern(
      'solvior/custom-pattern',
      [
        'title'       => __('Custom Pattern', 'solvior'),
        'description' => _x('A custom block pattern for solvior theme', 'Block pattern description', 'solvior'),
        'content'     => "<!-- wp:paragraph --><p>" . __('Hello World', 'solvior') . "</p><!-- /wp:paragraph -->",
      ]
    );
  }
}
add_action('init', 'solvior_register_block_features');


/**
 *  ---------------------------------------------------------------------------------------
 *  Set the content width in pixels, based on the theme's design and stylesheet.
 *  ---------------------------------------------------------------------------------------
 */
function solvior_content_width()
{
  // This variable is intended to be overruled from themes.
  // Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
  // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
  $GLOBALS['content_width'] = apply_filters('solvior_content_width', 1000);
}
add_action('after_setup_theme', 'solvior_content_width', 0);


/**
 * ---------------------------------------------------------------------------------------
 * Admin Custom Scripts
 * ---------------------------------------------------------------------------------------
 */
function solvior_admin_custom_scripts()
{
  wp_enqueue_media();
  wp_enqueue_style('solvior-customizer-style', SOLVIOR_INC_URL . '/assets/css/customizer-style.css', []);
}
add_action('admin_enqueue_scripts', 'solvior_admin_custom_scripts');



/**
 *    ---------------------------------------------------------------------------------------
 *    Register widget area.
 *
 *  @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 *    ---------------------------------------------------------------------------------------
 */
function solvior_widgets_init()
{
  require_once SOLVIOR_COMMON_DIR . '/template-widgets.php';
}
add_action('widgets_init', 'solvior_widgets_init');


/**
 * ---------------------------------------------------------------------------------------
 *  Enqueue scripts and styles.
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('solvior_scripts')) :
  require_once SOLVIOR_COMMON_DIR . '/template-scripts.php';
endif;


/**
 * ---------------------------------------------------------------------------------------
 * ReArrange Comment Form
 * ---------------------------------------------------------------------------------------
 */
function solvior_rearrange_comment_form($fields)
{
  $comment = $fields['comment'] ?? '';
  $author  = $fields['author'] ?? '';
  $email   = $fields['email'] ?? '';
  $url     = $fields['url'] ?? '';
  $cookies = $fields['cookies'] ?? '';

  unset($fields['comment'], $fields['author'], $fields['email'], $fields['url'], $fields['cookies']);

  $fields['author']  = $author;
  $fields['email']   = $email;

  // Add 'url' only if it's present
  if (!empty($url)) {
    $fields['url'] = $url;
  }

  $fields['comment'] = $comment;

  // Add 'cookies' only if it's present
  if (!empty($cookies)) {
    $fields['cookies'] = $cookies;
  }

  return $fields;
}
add_filter('comment_form_fields', 'solvior_rearrange_comment_form');


/**
 * ---------------------------------------------------------------------------------------
 * Body Class
 * ---------------------------------------------------------------------------------------
 */
function solvior_body_classes($classes)
{
  $enable_header_settings = function_exists('get_field') ? get_field('enable_header_settings') : false;
  $is_page_header_absolute = function_exists('get_field') ? get_field('is_page_header_absolute') : false;
  $is_page_header_sticky = function_exists('get_field') ? get_field('is_page_header_sticky') : false;

  $header_absolute = get_theme_mod('header_absolute', false);
  $header_sticky = get_theme_mod('header_sticky', false);

  if (!empty($enable_header_settings) && is_page()) {
    $isHeaderAbsolute = !empty($is_page_header_absolute) ? "absolute_header" : "";
    $isHeaderSticky = !empty($is_page_header_sticky) ? "sticky_header" : "";
  } else {
    $isHeaderAbsolute = !empty($header_absolute) ? "absolute_header" : "";
    $isHeaderSticky = !empty($header_sticky) ? "sticky_header" : "";
  }

  $classes[]    = $isHeaderAbsolute;
  $classes[]    = $isHeaderSticky;


  // add active header class
  $default_header_style   = get_theme_mod('default_header_style', 'header-style-1');
  $page_default_header_style = function_exists('get_field') ? get_field('page_default_header_style') : "";


  if (!empty($enable_header_settings) && is_page()) {
    $classes[]    = 'active_' . $page_default_header_style;
  } else {
    $classes[]    = 'active_' . $default_header_style;
  }

  // Adds a class of solvior_page to non-singular pages.
  if (!is_singular()) {
    $classes[] = 'solvior_page';
  }

  // Adds a class of no-sidebar when there is no sidebar present.
  if (!is_active_sidebar('blog-sidebar')) {
    $classes[] = 'no-sidebar';
  }

  return $classes;
}
add_filter('body_class', 'solvior_body_classes');
