<?php

/**
 * The template for displaying elementor template
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>


    <?php if (!function_exists('elementor_theme_do_location') || !elementor_theme_do_location('header')) {
        do_action('solvior_header_style');
    } ?>

    <section class="tj-elementor-area">
        <div class="entry-content">
            <?php
            while (have_posts()) :
                the_post();
                the_content();
            endwhile;
            ?>
        </div>
    </section>

    <?php
    if (!function_exists('elementor_theme_do_location') || !elementor_theme_do_location('footer')) {
        do_action('solvior_footer_style');
    }

    wp_footer(); ?>
</body>

</html>