<?php

/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

get_header();


$solviorBlogColumn = is_active_sidebar('blog-sidebar') ? 8 : 12;
$solviorBlogSocials = get_theme_mod('solvior_blog_socials', false);
?>

<section class="full-width tj-post-details__area section-space">
	<div class="container">
		<div class="row rg-50">
			<div class="col-lg-<?php print esc_attr($solviorBlogColumn); ?>">
				<!-- post details container -->
				<div class="tj-post-details__container tj-post-wrapper">
					<?php while (have_posts()) :
						the_post();
						get_template_part('template-parts/content', get_post_format());
					?>
						<?php if (has_tag() || !empty($solviorBlogSocials)) : ?>
							<!-- post tag & share -->
							<div class="tj-post-details_tags_share <?php echo (!empty($solviorBlogSocials) ? "" : "no-social-share"); ?>">
								<!-- post tags -->
								<?php if (has_tag()) {
									echo solvior_get_tag();
								}
								// post share
								if (!empty($solviorBlogSocials)) : ?>
									<div class="tj-socials_share">
										<span class="tag__title"><?php echo esc_html__('Share:', 'solvior'); ?></span>
										<a href="https://www.facebook.com/sharer?u=<?php the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="facebook" title="<?php echo esc_attr__('Share this on Facebook', 'solvior') ?>">
											<i class="fa-brands fa-facebook-f"></i>
										</a>
										<a href="http://twitter.com/intent/tweet?url=<?php the_permalink(); ?>" class="twitter" title="<?php echo esc_attr__('Share this on Twitter', 'solvior') ?>" target="_blank">
											<i class="fab fa-x-twitter"></i>
										</a>
										<a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php the_permalink() ?>&amp;summary=&amp;source=<?php bloginfo('name'); ?>" class="linkedin" title="<?php echo esc_attr__('Share this on Linkedin', 'solvior') ?>" target="_blank">
											<i class="fa-brands fa-linkedin-in"></i>
										</a>
										<a target="blank" href="http://pinterest.com/pin/create/button/?url=<?php the_permalink() ?>&media=<?php the_post_thumbnail_url('full'); ?>" class="pinteres" title="<?php echo esc_attr__('Pin This Post', 'solvior') ?>">
											<i class="fa-brands fa-pinterest-p"></i>
										</a>
									</div>
								<?php endif; ?>
							</div>
						<?php endif; ?>
						<!-- post pagination -->
						<?php if (get_previous_post_link() || get_next_post_link()) : ?>
							<div class="tj-post__navigation">
								<!-- previous post -->
								<?php
								$prevPost = get_adjacent_post(false, '', true);;
								?>
								<?php if (is_a($prevPost, 'WP_Post')) :
									$prevLink = get_permalink($prevPost->ID);
								?>
									<div class="tj-nav__post previous">
										<div class="tj-nav-post__nav prev_post">
											<a href="<?php echo esc_url($prevLink); ?>">
												<span><i class="tji-arrow-left"></i></span><?php echo esc_html__('previous', 'solvior'); ?>
											</a>
										</div>
									</div>
								<?php endif; ?>
								<div class="tj-nav-post__grid">
									<i class="tji-square-cube"></i>
								</div>
								<!-- next post -->
								<?php
								$nextPost = get_adjacent_post(false, '', false);
								?>
								<?php
								if (is_a($nextPost, 'WP_Post')) :
									$nextLink = get_permalink($nextPost->ID);
								?>
									<div class="tj-nav__post next">
										<div class="tj-nav-post__nav next_post">
											<a href="<?php echo esc_url($nextLink); ?>"><?php echo esc_html__('Next', 'solvior'); ?><span><i class="tji-arrow-right"></i></span></a>
										</div>
									</div>
								<?php endif; ?>
							</div>
						<?php endif; ?>
					<?php
						// If comments are open or we have at least one comment, load up the comment template.
						if (comments_open() || get_comments_number()) :
							comments_template();
						endif;

					endwhile; // End of the loop.
					?>
				</div>
				<!-- !post details container -->
			</div>
			<?php if (is_active_sidebar('blog-sidebar')) : ?>
				<!-- sidebar -->
				<div class="col-lg-4">
					<aside class="tj-main__sidebar tj-post-sidebar">
						<?php get_sidebar(); ?>
					</aside>
				</div> <!-- !sidebar -->
			<?php endif; ?>
		</div>
	</div>
</section>

<?php
get_footer();
