<?php

/**
 * Template part for displaying post btn
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

$showBlogBtn = get_theme_mod('show_blog_btn', true);
$blogBtnText = get_theme_mod('blog_btn_text', esc_html__('Read more', 'solvior'));
?>
<?php if (!empty($showBlogBtn)) : ?>
  <div class="tj-post-btn">
    <a href="<?php the_permalink(); ?>" class="tj-primary-btn">
      <span class="btn_inner">
        <span class="btn_icon">
          <span>
            <i class="tji-arrow-right"></i>
            <i class="tji-arrow-right"></i>
          </span>
        </span>
        <span class="btn_text"><span><?php echo esc_html($blogBtnText); ?></span></span>
      </span>
    </a>
  </div>
<?php endif; ?>