<?php

/**
 * Template part for displaying post meta
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

$solviorBlogAuthor = get_theme_mod('solvior_blog_single_author', true);
$solviorBlogDate = get_theme_mod('solvior_blog_single_date', true);
$solviorBlogComments = get_theme_mod('solvior_blog_single_comments', true);

$solviorBlogAuthorLabel = get_theme_mod('solvior_blog_single_author_label', esc_html__('Authored by', 'solvior'));
$solviorBlogDateLabel = get_theme_mod('solvior_blog_single_date_label', esc_html__('Date Released', 'solvior'));
$solviorBlogCommentsLabel = get_theme_mod('solvior_blog_single_comments_label', esc_html__('Comments', 'solvior'));

if (!empty($solviorBlogAuthor || $solviorBlogDate || $solviorBlogComments)) : ?>

  <div class="blog-category-two">
    <?php if (!empty($solviorBlogAuthor)) : ?>
      <div class="category-item">
        <div class="cate-images">
          <img src="<?php echo esc_url(get_avatar_url(get_the_author_meta('ID'))); ?>" alt="Images">
        </div>
        <div class="cate-text">
          <?php if (!empty($solviorBlogAuthorLabel)): ?>
            <span class="degination"><?php echo esc_html($solviorBlogAuthorLabel); ?></span>
          <?php endif; ?>
          <h6 class="title"><?php printf('<a href="%s">%s</a>', esc_url(get_author_posts_url(get_the_author_meta('ID'))), get_the_author()); ?></h6>
        </div>
      </div>
    <?php endif; ?>
    <?php if (!empty($solviorBlogDate)) : ?>
      <div class="category-item">
        <div class="cate-icons">
          <i class="tji-calender"></i>
        </div>
        <div class="cate-text">
          <?php if (!empty($solviorBlogDateLabel)): ?>
            <span class="degination"><?php echo esc_html($solviorBlogDateLabel); ?></span>
          <?php endif; ?>
          <h6 class="text"><?php the_time(get_option('date_format')); ?></h6>
        </div>
      </div>
    <?php endif; ?>
    <?php if (!empty($solviorBlogComments)) : ?>
      <div class="category-item">
        <div class="cate-icons">
          <i class="tji-coments"></i>
        </div>
        <div class="cate-text">
          <?php if (!empty($solviorBlogCommentsLabel)): ?>
            <span class="degination"><?php echo esc_html($solviorBlogCommentsLabel); ?></span>
          <?php endif; ?>
          <h6 class="text"><?php comments_number(); ?></h6>
        </div>
      </div>
    <?php endif; ?>
  </div>
<?php endif; ?>