<?php

/**
 * Template part for displaying post meta
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

$categories = get_the_terms($post->ID, 'category');
$solviorBlogComments = get_theme_mod('solvior_blog_comments', true);
$solviorBlogCat = get_theme_mod('solvior_blog_cat', true);

if (!empty($solviorBlogCat || $solviorBlogComments)) : ?>

  <div class="tj-post-meta">
    <ul>
      <?php if (!empty($solviorBlogCat)) : ?>
        <li>
          <?php if (!empty($categories[0]->name)) : ?>
            <a href="<?php echo esc_url(get_category_link($categories[0]->term_id)); ?>"><?php echo esc_html($categories[0]->name); ?></a>
          <?php endif; ?>
        </li>
      <?php endif; ?>
      <?php if (!empty($solviorBlogComments)) : ?>
        <li>
          <span><?php comments_number(); ?></span>
        </li>
      <?php endif; ?>
    </ul>
  </div>
<?php endif; ?>