<?php

/**
 * Template part for displaying video posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

// get video url
$solviorVideoLink = function_exists('get_field') ? get_field('post_video_link') : "";
$solviorBlogDate = get_theme_mod('solvior_blog_date', true);
if (is_single()) : ?>

  <!-- single post -->
  <article id="post-<?php the_ID(); ?>" <?php post_class("tj-single__post tj-post-single-post"); ?>>
    <?php if (has_post_thumbnail()) : ?>
      <!-- post thumbnail -->
      <div class="tj-post-thumb hover:shine">
        <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
        <?php if (!empty($solviorVideoLink)) : ?>
          <a data-autoplay="true" data-vbtype="video" data-maxwidth="1200px" href="<?php echo esc_url($solviorVideoLink); ?>" class="play-btn video-popup">
            <i class="fa-sharp fa-solid fa-play"></i>
          </a>
        <?php endif; ?>
      </div>
    <?php endif; ?>
    <div class="tj-post__content">
      <!-- entry title -->
      <?php the_title('<h3 class="tj-post-title entry-title">', '</h3>'); ?>
      <!-- entry-meta -->
      <?php get_template_part('template-parts/blog/post-meta-single'); ?>
      <!-- entry content -->
      <div class="tj-entry__content tj-entry-content">
        <?php the_content(); ?>
        <?php
        wp_link_pages([
          'before'      => '<div class="tj-page__links"> <span class="tj-page-links__title">' . esc_html__('Pages:', 'solvior') . '</span>',
          'after'       => '</div>',
          'link_before' => '<span>',
          'link_after'  => '</span>',
          'pagelink'    => '<span class="screen-reader-text">' . esc_html__('Page', 'solvior') . ' </span>%',
          'separator'   => '<span class="screen-reader-text"> </span>',
        ]);
        ?>
      </div>
    </div>
  </article>
  <!-- !single post -->

<?php else : ?>

  <!-- post-<?php the_ID(); ?> -->
  <article id="post-<?php the_ID(); ?>" <?php post_class("tj__post tj-post-item video"); ?>>

    <?php if (has_post_thumbnail()) : ?>
      <!-- post thumbnail -->
      <div class="tj-post-thumb">
        <a href="<?php the_permalink(); ?>">
          <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
        </a>
        <?php if (!empty($solviorVideoLink)) : ?>
          <a data-autoplay="true" data-vbtype="video" data-maxwidth="1200px" href="<?php echo esc_url($solviorVideoLink); ?>" class="play-btn video-popup">
            <i class="fa-sharp fa-solid fa-play"></i>
          </a>
        <?php endif; ?>
        <?php if (!empty($solviorBlogDate)) : ?>
          <div class="tj-post-date">
            <span class="date"><?php echo get_the_date('d'); ?></span>
            <span class="month"><?php echo get_the_date('M'); ?></span>
          </div>
        <?php endif; ?>
      </div>
    <?php endif; ?>
    <div class="tj-post__content tj-post-content">
      <!-- entry-meta -->
      <?php get_template_part('template-parts/blog/post-meta'); ?>
      <!-- entry title -->
      <?php the_title('<h3 class="tj-post-title entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>
      <?php if (get_the_excerpt()): ?>
        <!-- excerpt -->
        <div class="tj-post-excerpt excerpt"><?php echo wp_trim_words(get_the_excerpt(), '40', '...'); ?></div>
      <?php endif; ?>
      <!-- post btn -->
      <?php get_template_part('template-parts/blog/post-btn'); ?>
    </div>
    <div class="tj-clearfix"></div>
  </article><!-- !post-<?php the_ID(); ?> -->

<?php endif; ?>