<?php

/**
 * Template part for displaying footer layout one
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

// from page
$enable_footer_settings = function_exists('get_field') ? get_field('enable_footer_settings') : false;
$page_footer_bg_img = function_exists('get_field') ? get_field('page_footer_bg_img') : '';
$page_footer_bg_color = function_exists('get_field') ? get_field('page_footer_bg_color') : "";
$page_footer_menu = function_exists('get_field') ? get_field('page_footer_menu') : false;

// multifunction
if (!empty($enable_footer_settings) && is_page()) {
  $footerBgImage = !empty($page_footer_bg_img['url']) ? $page_footer_bg_img['url'] : get_theme_mod('footer_bg_img');
  $footerBgColor = !empty($page_footer_bg_color) ? $page_footer_bg_color : get_theme_mod('footer_bg_color', "");

  $footerMenu = $page_footer_menu;
  $copyright_class = !empty($footerMenu) ? 'justify-content-center justify-content-lg-between' : 'justify-content-center';
} else {
  $footerBgImage = get_theme_mod('footer_bg_img');
  $footerBgColor = get_theme_mod('footer_bg_color', "");

  $footerMenu = get_theme_mod('footer_menu_switcher', false);
  $copyright_class = !empty($footerMenu) ? 'justify-content-center justify-content-lg-between' : 'justify-content-center';
}

// footer_columns
$footer_column = 0;
$footer_column = get_theme_mod('footer_widget_column', 4);

switch ($footer_column) {
  case '1':
    $footer_class[1] = 'col-12';
    break;
  case '2':
    $footer_class[1] = 'col-md-6';
    $footer_class[2] = 'col-md-6';
    break;
  case '3':
    $footer_class[1] = 'col-lg-4 col-md-6';
    $footer_class[2] = 'col-lg-4 col-md-6';
    $footer_class[3] = 'col-lg-4 col-md-6';
    break;
  case '4':
    $footer_class[1] = 'col-xl-3 col-md-6';
    $footer_class[2] = 'col-xl-3 col-md-6';
    $footer_class[3] = 'col-xl-3 col-md-6';
    $footer_class[4] = 'col-xl-3 col-md-6';
    break;
  default:
    $footer_class = 'col-xl-3 col-lg-6 col-md-6';
    break;
}

// footer bg color
if (!empty($footerBgColor)) {
  $bgColor = 'data-bg-color=' . $footerBgColor . '';
} else {
  $bgColor = "";
}

// footer bg image
if (!empty($footerBgImage)) {
  $bgImage = 'data-bg-image=' . $footerBgImage . '';
} else {
  $bgImage = "";
}
?>

<!-- start: Footer Section -->
<footer class="tj-footer-area" <?php echo esc_attr($bgColor); ?> <?php echo esc_attr($bgImage); ?>>

  <?php if (is_active_sidebar('footer-1') or is_active_sidebar('footer-2') or is_active_sidebar('footer-3') or is_active_sidebar('footer-4')) : ?>
    <!-- footer widgets -->
    <div class="footer-top-area fix">
      <div class="container">
        <div class="row">
          <?php for ($num = 1; $num <= $footer_column; $num++) {

            echo '<div class="' . esc_attr($footer_class[$num]) . '">';
            dynamic_sidebar('footer-' . $num);
            echo '</div>';
          } ?>
        </div>
      </div>
    </div>
  <?php endif; ?>
  <div class="footer-copyright-area">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <div class="copyright-content-area <?php echo esc_attr($copyright_class); ?>">
            <div class="copyright-text">
              <p><?php echo solvior_copyright_text(); ?></p>
            </div>
            <?php if (!empty($footerMenu)) : ?>
              <div class="copyright-menu">
                <?php if (has_nav_menu('footer-menu')) {
                  solvior_footer_menu();
                } ?>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</footer>

<!-- end: Footer Section -->