<?php

/**
 * Template part for displaying header layout One
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Solvior_Theme
 * @since Solvior 1.0.0
 * @author Theme Junction 
 */

// from Page
$enable_header_settings = function_exists('get_field') ? get_field('enable_header_settings') : false;
$is_page_header_sticky = function_exists('get_field') ? get_field('is_page_header_sticky') : false;
$is_page_header_absolute = function_exists('get_field') ? get_field('is_page_header_absolute') : false;

$page_header_search = function_exists('get_field') ? get_field('page_header_search') : false;
$page_header_button = function_exists('get_field') ? get_field('page_header_button') : false;

// info
$header_sticky = get_theme_mod('header_sticky', false);
$header_absolute = get_theme_mod('header_absolute', false);

$contactPhoneNumber = get_theme_mod('contact_phone_number', esc_attr('+123 456-7890'));
$phoneNumberUrl = preg_replace('/(?!^\+)[^\d]/', '', $contactPhoneNumber);
$contactEmail = get_theme_mod('contact_email', esc_attr('info@solvior.com'));
$contactLocation = get_theme_mod('contact_location', esc_html__('Westheimer Rd. Santa Ana, Illinois 937949', 'solvior'));

// multi condition
if (!empty($enable_header_settings) && is_page()) {
  $isHeaderSticky = !empty($is_page_header_sticky) ? "header-sticky" : "";
  $isHeaderAbsolute = !empty($is_page_header_absolute) ? "header-absolute" : "";

  // header right
  $header_btn_text = function_exists('get_field') ? get_field('page_header_button_text') : '';
  $header_btn_url = function_exists('get_field') ? get_field('page_header_button_link') : '';
  $showHeaderSearch = $page_header_search;
  $showHeaderButton = $page_header_button;
} else {

  $isHeaderSticky = !empty($header_sticky) ? "header-sticky" : "";
  $isHeaderAbsolute = !empty($header_absolute) ? "header-absolute" : "";

  // header right
  $header_btn_text = get_theme_mod('header_btn_text', __('Get a quote', 'solvior'));
  $header_btn_url = get_theme_mod('header_btn_url', __('#', 'solvior'));
  $showHeaderSearch = get_theme_mod('show_header_search', false);
  $showHeaderButton = get_theme_mod('show_header_button', false);
}
$logoSpace = has_nav_menu('main-menu') ? '' : 'logo-space';
?>

<!-- start: Header -->
<header class="tj-header-area header-1 wp-header <?php printf("%s", esc_attr($isHeaderAbsolute)); ?>">
  <div class="header-bottom">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
          <div class="header-wrapper">
            <!-- logo -->
            <div class="site-logo <?php printf("%s", esc_attr($logoSpace)); ?>">
              <?php solvior_header_logo(); ?>
            </div>
            <!-- main navigation -->
            <div class="mainmenu d-lg-block d-none" id="main-menu">
              <?php solvior_header_menu(); ?>
            </div>
            <?php if (!empty($showHeaderSearch || $showHeaderButton)) : ?>
              <div class="header_right_info d-none d-md-inline-flex">
                <?php if (!empty($showHeaderSearch)) : ?>
                  <!-- search btn -->
                  <button class="header_search d-none d-lg-inline-flex">
                    <?php echo esc_html__('Explore', 'solvior'); ?>
                    <i class="tji-search"></i>
                  </button>
                <?php endif; ?>
                <?php if (!empty($showHeaderButton)) : ?>
                  <!-- button -->
                  <a href="<?php echo esc_url($header_btn_url); ?>" class="tj-primary-btn header_btn">
                    <span class="btn_inner">
                      <span class="btn_icon">
                        <span>
                          <i class="tji-arrow-right"></i>
                          <i class="tji-arrow-right"></i>
                        </span>
                      </span>
                      <span class="btn_text">
                        <span><?php echo esc_html($header_btn_text); ?></span>
                      </span>
                    </span>
                  </a>
                <?php endif; ?>
              </div>
            <?php endif; ?>
            <?php if (has_nav_menu('main-menu')) : ?>
              <!-- menu bar -->
              <button class="menu_btn d-lg-none hamburgerBtn">
                <?php echo esc_html__('Menu', 'solvior'); ?>
                <i class="tji-cube"></i>
              </button>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</header>

<header class="tj-header-area header-1 header-duplicate <?php printf("%s", esc_attr($isHeaderSticky)); ?>">
  <div class="header-bottom">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
          <div class="header-wrapper">
            <!-- logo -->
            <div class="site-logo">
              <?php solvior_header_logo(); ?>
            </div>
            <!-- main navigation -->
            <div class="mainmenu d-lg-block d-none" id="main-menu">
              <?php solvior_header_menu(); ?>
            </div>
            <?php if (!empty($showHeaderSearch || $showHeaderButton)) : ?>
              <div class="header_right_info d-none d-md-inline-flex">
                <?php if (!empty($showHeaderSearch)) : ?>
                  <!-- search btn -->
                  <button class="header_search d-none d-lg-inline-flex">
                    <?php echo esc_html__('Explore', 'solvior'); ?>
                    <i class="tji-search"></i>
                  </button>
                <?php endif; ?>
                <?php if (!empty($showHeaderButton)) : ?>
                  <!-- button -->
                  <a href="<?php echo esc_url($header_btn_url); ?>" class="tj-primary-btn header_btn">
                    <span class="btn_inner">
                      <span class="btn_icon">
                        <span>
                          <i class="tji-arrow-right"></i>
                          <i class="tji-arrow-right"></i>
                        </span>
                      </span>
                      <span class="btn_text">
                        <span><?php echo esc_html($header_btn_text); ?></span>
                      </span>
                    </span>
                  </a>
                <?php endif; ?>
              </div>
            <?php endif; ?>
            <!-- menu bar -->
            <button class="menu_btn d-lg-none hamburgerBtn">
              <?php echo esc_html__('Menu', 'solvior'); ?>
              <i class="tji-cube"></i>
            </button>
          </div>
        </div>
      </div>
    </div>
  </div>
</header>
<!-- end: Header -->


<?php if (!empty($showHeaderSearch)):

  $header_search_text = get_theme_mod('header_search_text', __('Search blog, projects, service.', 'solvior'));

?>
  <!-- start: Search Popup -->
  <div class="search_popup">
    <div class="search_close">
      <button type="button" class="search_close_btn">
        <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
          <path d="M17 1L1 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
            stroke-linejoin="round" />
          <path d="M1 1L17 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
            stroke-linejoin="round" />
        </svg>
      </button>
    </div>
    <div class="container">
      <div class="row">
        <div class="col-xxl-12">
          <div class="tj_search_wrapper">
            <div class="search_form">
              <form action="<?php echo esc_url(home_url('/')); ?>">
                <div class="search_input">
                  <?php if (!empty($header_search_text)) : ?>
                    <h4 class="title"><?php echo esc_html($header_search_text); ?></h4>
                  <?php endif; ?>
                  <div class="search-box">
                    <input class="search-input-field" type="search" placeholder="Search here..." required="">
                    <input class="search-input-field" type="search" placeholder="<?php echo esc_attr__('Search here...', 'solvior'); ?>" value="<?php echo esc_attr(get_search_query()); ?>" required name="s" />
                    <button type="submit">
                      <i class="tji-search"></i>
                    </button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="search-popup-overlay"></div>
  <!-- end: Search Popup -->
<?php endif; ?>

<?php
$mobileSearch = get_theme_mod('solvior_mobile_search', false);
$mobileDesc = get_theme_mod('solvior_mobile_desc', "");
$mobileContact = get_theme_mod('show_mobile_contact', false);
$mobileContactTitle = get_theme_mod('contact_info_title', esc_html__('Contact Info', 'solvior'));
$mobileSocials = get_theme_mod('show_mobile_socials', false);
$mobileSocialsTitle = get_theme_mod('social_info_title', esc_html__('Follow Us', 'solvior'));
?>
<!-- start: Hamburger Menu -->
<div class="body-overlay d-lg-none"></div>
<div class="hamburger-area d-lg-none" data-lenis-prevent>
  <div class="hamburger_bg"></div>
  <div class="hamburger_wrapper">
    <div class="hamburger_top d-flex align-items-center justify-content-between">
      <!-- mobile logo -->
      <div class="hamburger_logo logo-area">
        <?php solvior_mobile_logo(); ?>
      </div>
      <!-- close btn -->
      <div class="hamburger_close">
        <button class="hamburger_close_btn hamburgerCloseBtn"><i class="fa-thin fa-times"></i></button>
      </div>
    </div>

    <?php if (!empty($mobileDesc)): ?>
      <!-- desc -->
      <div class="desc">
        <?php echo solvior_kses($mobileDesc); ?>
      </div>
    <?php endif; ?>

    <?php if (!empty($mobileSearch)): ?>
      <div class="hamburger_search">
        <form method="get" action="index.html">
          <button type="submit"><i class="fal fa-search"></i></button>
          <input type="search" placeholder="<?php echo esc_attr__('Search here', 'solvior'); ?>" value="<?php echo esc_attr(get_search_query()); ?>" required name="s" />
        </form>
      </div>
    <?php endif; ?>
    <!-- mobile menu -->
    <div class="hamburger_menu">
      <div class="mobile_menu"></div>
    </div>
    <!-- contact info -->
    <?php if (!empty($mobileContact)): ?>
      <div class="hamburger-infos">
        <?php if (!empty($mobileContactTitle)): ?>
          <h4 class="hamburger-title"><?php echo esc_html($mobileContactTitle); ?></h4>
        <?php endif; ?>

        <?php if (!empty($contactEmail)): ?>
          <div class="contact_item">
            <div class="text">
              <a class="link" href="mailto:<?php echo esc_attr($contactEmail); ?>"><?php echo esc_html($contactEmail); ?></a>
            </div>
          </div>
        <?php endif; ?>
        <?php if (!empty($contactPhoneNumber)): ?>
          <div class="contact_item">
            <div class="text">
              <a class="link" href="tel:<?php echo esc_attr($phoneNumberUrl); ?>">
                <?php echo esc_html($contactPhoneNumber); ?>
              </a>
            </div>
          </div>
        <?php endif; ?>
        <?php if (!empty($contactLocation)): ?>
          <div class="contact_item">
            <div class="text"><?php echo solvior_kses($contactLocation); ?></div>
          </div>
        <?php endif; ?>
      </div>
    <?php endif; ?>

    <?php if (!empty($mobileSocials)): ?>
      <!-- socials -->
      <div class="hamburger-socials">
        <?php if (!empty($mobileSocialsTitle)): ?>
          <h4 class="hamburger-title"><?php echo esc_html($mobileSocialsTitle); ?></h4>
        <?php endif; ?>
        <?php solvior_socials(); ?>
      </div>
    <?php endif; ?>
  </div>
</div>

<!-- end: Hamburger Menu -->