<?php

/**
 * External product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/external.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined('ABSPATH') || exit;
global $product;


do_action('woocommerce_before_add_to_cart_form'); ?>
<div class="product__details-action">
    <form class="cart" action="<?php echo esc_url($product_url); ?>" method="get">
        <?php do_action('woocommerce_before_add_to_cart_button'); ?>

        <div class="tj-product-details-add-to-cart">
            <button type="submit" name="add-to-cart" value="<?php echo esc_attr($product->get_id()); ?>" class="single_add_to_cart_button tj-cart-btn <?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>">
                <span class="btn-icon"><i class="fal fa-shopping-cart"></i><i class="fal fa-shopping-cart"></i></span>
                <span class="btn-text"><span><?php echo esc_html($product->single_add_to_cart_text()); ?></span></span>
            </button>
        </div>

        <?php wc_query_string_form_fields($product_url); ?>

        <?php do_action('woocommerce_after_add_to_cart_button'); ?>
    </form>
</div>

<?php do_action('woocommerce_after_add_to_cart_form'); ?>